/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal.provision;

import java.util.HashMap;
import java.util.Locale;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.provision.BaseDelegatedClientUserProfileProvisioner;
import org.apereo.cas.configuration.model.RestEndpointProperties;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.pac4j.core.client.BaseClient;
import org.pac4j.core.profile.UserProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestfulDelegatedClientUserProfileProvisioner
extends BaseDelegatedClientUserProfileProvisioner {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulDelegatedClientUserProfileProvisioner.class);
    private final RestEndpointProperties restProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Principal principal, UserProfile profile, BaseClient client, Credential credential) {
        HttpResponse response = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("principalId", principal.getId());
            headers.put("principalAttributes", principal.getAttributes().toString());
            headers.put("profileId", profile.getId());
            headers.put("profileTypedId", profile.getTypedId());
            headers.put("profileAttributes", profile.getAttributes().toString());
            headers.put("clientName", client.getName());
            headers.putAll(this.restProperties.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().basicAuthPassword(this.restProperties.getBasicAuthPassword()).basicAuthUsername(this.restProperties.getBasicAuthUsername()).method(HttpMethod.valueOf((String)this.restProperties.getMethod().toUpperCase(Locale.ENGLISH).trim())).url(this.restProperties.getUrl()).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            if (response != null) {
                HttpStatus status = HttpStatus.valueOf((int)response.getCode());
                LOGGER.debug("Provisioned principal [{}] with status result [{}]", (Object)principal.getId(), (Object)status);
            }
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
    }

    @Generated
    public RestfulDelegatedClientUserProfileProvisioner(RestEndpointProperties restProperties) {
        this.restProperties = restProperties;
    }
}

