/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.ui.commons.markup.html.form.preview;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.DefaultResourceCache;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.ResourceCache;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.syncope.client.ui.commons.annotations.BinaryPreview;
import org.apache.syncope.client.ui.commons.markup.html.form.preview.BinaryPreviewer;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.request.resource.DynamicImageResource;
import org.apache.wicket.request.resource.IResource;

@BinaryPreview(mimeTypes={"application/pdf"})
public class BinaryPDFPreviewer
extends BinaryPreviewer {
    private static final long serialVersionUID = -6606409541566687016L;
    private static final int IMG_SIZE = 300;
    private static final float DPI = 100.0f;
    private static final ImageType IMAGE_TYPE = ImageType.RGB;
    private transient BufferedImage firstPage;

    public BinaryPDFPreviewer(String mimeType) {
        super(mimeType);
    }

    @Override
    public Component preview(byte[] uploadedBytes) {
        Fragment fragment;
        this.firstPage = null;
        try (PDDocument document = Loader.loadPDF((byte[])uploadedBytes);){
            document.setResourceCache((ResourceCache)new DefaultResourceCache(this){

                public void put(COSObject indirect, PDXObject xobject) {
                }
            });
            if (document.isEncrypted()) {
                LOG.info("Document is encrypted, no preview is possible");
            } else {
                this.firstPage = new PDFRenderer(document).renderImageWithDPI(0, 100.0f, IMAGE_TYPE);
            }
        }
        catch (IOException e) {
            LOG.error("While generating thumbnail from first page", (Throwable)e);
        }
        if (this.firstPage == null) {
            fragment = new Fragment("preview", "noPreviewFragment", (MarkupContainer)this);
        } else {
            fragment = new Fragment("preview", "previewFragment", (MarkupContainer)this);
            fragment.add(new Component[]{new NonCachingImage("previewImage", (IResource)new ThumbnailImageResource(this.firstPage))});
        }
        WebMarkupContainer previewContainer = new WebMarkupContainer("previewContainer");
        previewContainer.setOutputMarkupId(true);
        previewContainer.add(new Component[]{fragment});
        return this.addOrReplace(new Component[]{previewContainer});
    }

    protected static class ThumbnailImageResource
    extends DynamicImageResource
    implements Serializable {
        private static final long serialVersionUID = 923201517955737928L;
        protected final transient BufferedImage image;
        protected transient byte[] thumbnail;

        protected ThumbnailImageResource(BufferedImage image) {
            this.image = image;
        }

        protected byte[] getImageData(IResource.Attributes attributes) {
            if (this.thumbnail == null) {
                this.thumbnail = this.toImageData(this.getScaledImageInstance());
                this.setLastModifiedTime(Instant.now());
            }
            return this.thumbnail;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected BufferedImage getScaledImageInstance() {
            int originalWidth = this.image.getWidth();
            int originalHeight = this.image.getHeight();
            if (originalWidth > 300 || originalHeight > 300) {
                int newHeight;
                int newWidth;
                if (originalWidth > originalHeight) {
                    newWidth = 300;
                    newHeight = 300 * originalHeight / originalWidth;
                } else {
                    newWidth = 300 * originalWidth / originalHeight;
                    newHeight = 300;
                }
                BufferedImage dimg = new BufferedImage(newWidth, newHeight, this.image.getType());
                Graphics2D g = dimg.createGraphics();
                try {
                    g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                    g.drawImage(this.image, 0, 0, newWidth, newHeight, 0, 0, originalWidth, originalHeight, null);
                }
                finally {
                    g.dispose();
                }
                return dimg;
            }
            return this.image;
        }
    }
}

