/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.content;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.syncope.core.persistence.api.content.ContentExporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractXMLContentExporter
implements ContentExporter {
    protected static final Logger LOG = LoggerFactory.getLogger(ContentExporter.class);

    protected TransformerHandler start(OutputStream os) throws TransformerConfigurationException, SAXException {
        StreamResult streamResult = new StreamResult(os);
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        TransformerHandler handler = transformerFactory.newTransformerHandler();
        Transformer serializer = handler.getTransformer();
        serializer.setOutputProperty("encoding", StandardCharsets.UTF_8.name());
        serializer.setOutputProperty("indent", "yes");
        handler.setResult(streamResult);
        handler.startDocument();
        handler.startElement("", "", "dataset", new AttributesImpl());
        return handler;
    }

    protected void end(TransformerHandler handler) throws SAXException {
        handler.endElement("", "", "dataset");
        handler.endDocument();
    }
}

