/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.ApplicationContextProvider;
import org.apache.syncope.core.persistence.api.dao.PlainSchemaDAO;
import org.apache.syncope.core.persistence.api.entity.Attributable;
import org.apache.syncope.core.persistence.api.entity.PlainAttr;
import org.apache.syncope.core.persistence.api.entity.PlainAttrValue;
import org.apache.syncope.core.persistence.api.entity.PlainSchema;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.AttributableCheck;

public class AttributableValidator
extends AbstractValidator<AttributableCheck, Attributable> {
    protected boolean isValid(PlainAttr attr, PlainSchema schema, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (attr == null) {
            isValid = true;
        } else {
            if (schema.isUniqueConstraint()) {
                isValid = attr.getValues().isEmpty() && attr.getUniqueValue() != null;
            } else {
                boolean bl = isValid = !attr.getValues().isEmpty() && attr.getUniqueValue() == null;
                if (!schema.isMultivalue()) {
                    isValid &= attr.getValues().size() == 1;
                }
            }
            if (!isValid) {
                LOG.error("Invalid values for attribute schema={}, values={}", (Object)attr.getSchema(), (Object)attr.getValuesAsStrings());
                context.buildConstraintViolationWithTemplate(AttributableValidator.getTemplate(EntityViolationType.InvalidValueList, "Invalid values " + String.valueOf(attr.getValuesAsStrings()))).addPropertyNode(attr.getSchema()).addConstraintViolation();
            }
        }
        return isValid;
    }

    protected boolean isValid(PlainAttrValue value, ConstraintValidatorContext context) {
        boolean isValid;
        context.disableDefaultConstraintViolation();
        if (value == null) {
            isValid = true;
        } else {
            int nonNullVales = 0;
            if (value.getBooleanValue() != null) {
                ++nonNullVales;
            }
            if (value.getDateValue() != null) {
                ++nonNullVales;
            }
            if (value.getDoubleValue() != null) {
                ++nonNullVales;
            }
            if (value.getLongValue() != null) {
                ++nonNullVales;
            }
            if (value.getBinaryValue() != null) {
                ++nonNullVales;
            }
            if (value.getStringValue() != null) {
                ++nonNullVales;
            }
            boolean bl = isValid = nonNullVales == 1;
            if (!isValid) {
                LOG.error("More than one non-null value for {}", (Object)value);
                context.buildConstraintViolationWithTemplate(AttributableValidator.getTemplate(EntityViolationType.MoreThanOneNonNull, "More than one non-null value found")).addPropertyNode(value.getClass().getSimpleName().replaceAll("\\n", " ")).addConstraintViolation();
            }
        }
        return isValid;
    }

    public boolean isValid(Attributable entity, ConstraintValidatorContext context) {
        PlainSchemaDAO schemaDAO = (PlainSchemaDAO)ApplicationContextProvider.getApplicationContext().getBean(PlainSchemaDAO.class);
        context.disableDefaultConstraintViolation();
        MutableObject isValid = new MutableObject((Object)true);
        entity.getPlainAttrs().forEach(arg_0 -> this.lambda$isValid$3(schemaDAO, (Mutable)isValid, context, arg_0));
        return (Boolean)isValid.get();
    }

    private /* synthetic */ void lambda$isValid$3(PlainSchemaDAO schemaDAO, Mutable isValid, ConstraintValidatorContext context, PlainAttr attr) {
        schemaDAO.findById(attr.getSchema()).ifPresentOrElse(schema -> {
            isValid.setValue((Object)((Boolean)isValid.get() != false && this.isValid(attr, (PlainSchema)schema, context) ? 1 : 0));
            attr.getValues().forEach(value -> isValid.setValue((Object)((Boolean)isValid.get() != false && this.isValid((PlainAttrValue)value, context) ? 1 : 0)));
        }, () -> {
            isValid.setValue((Object)false);
            context.buildConstraintViolationWithTemplate(AttributableValidator.getTemplate(EntityViolationType.InvalidSchema, "Invalid schema " + attr.getSchema())).addPropertyNode(attr.getSchema()).addConstraintViolation();
        });
    }
}

