/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.common.validation;

import jakarta.validation.ConstraintValidatorContext;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.syncope.common.lib.types.EntityViolationType;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.entity.Schema;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.api.entity.user.User;
import org.apache.syncope.core.persistence.common.validation.AbstractValidator;
import org.apache.syncope.core.persistence.common.validation.SchemaKeyCheck;
import org.springframework.beans.BeanUtils;

public class SchemaKeyValidator
extends AbstractValidator<SchemaKeyCheck, Schema> {
    protected static final Set<String> ANY_FIELDS = new HashSet<String>();

    public boolean isValid(Schema schema, ConstraintValidatorContext context) {
        if (schema.getKey() == null || !Entity.ID_PATTERN.matcher(schema.getKey()).matches()) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(SchemaKeyValidator.getTemplate(EntityViolationType.InvalidKey, schema.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        if (ANY_FIELDS.contains(schema.getKey())) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(SchemaKeyValidator.getTemplate(EntityViolationType.InvalidKey, "Schema key not allowed: " + schema.getKey())).addPropertyNode("key").addConstraintViolation();
            return false;
        }
        return true;
    }

    static {
        ANY_FIELDS.add("id");
        Stream.of(User.class, Group.class, AnyObject.class).forEach(clazz -> {
            for (PropertyDescriptor pd : BeanUtils.getPropertyDescriptors((Class)clazz)) {
                ANY_FIELDS.add(pd.getName());
            }
        });
    }
}

