/*
 * Decompiled with CFR 0.152.
 */
package io.zonky.test.db.postgres.junit;

import io.zonky.test.db.postgres.embedded.EmbeddedPostgres;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.junit.rules.ExternalResource;

public class SingleInstancePostgresRule
extends ExternalResource {
    private volatile EmbeddedPostgres epg;
    private volatile Connection postgresConnection;
    private final List<Consumer<EmbeddedPostgres.Builder>> builderCustomizers = new CopyOnWriteArrayList<Consumer<EmbeddedPostgres.Builder>>();

    SingleInstancePostgresRule() {
    }

    protected void before() throws Throwable {
        super.before();
        this.epg = this.pg();
        this.postgresConnection = this.epg.getPostgresDatabase().getConnection();
    }

    private EmbeddedPostgres pg() throws IOException {
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        this.builderCustomizers.forEach(c -> c.accept(builder));
        return builder.start();
    }

    public SingleInstancePostgresRule customize(Consumer<EmbeddedPostgres.Builder> customizer) {
        if (this.epg != null) {
            throw new AssertionError((Object)"already started");
        }
        this.builderCustomizers.add(customizer);
        return this;
    }

    public EmbeddedPostgres getEmbeddedPostgres() {
        EmbeddedPostgres epg = this.epg;
        if (epg == null) {
            throw new AssertionError((Object)"JUnit test not started yet!");
        }
        return epg;
    }

    protected void after() {
        try {
            this.postgresConnection.close();
        }
        catch (SQLException e) {
            throw new AssertionError((Object)e);
        }
        try {
            this.epg.close();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

