/*
 * Decompiled with CFR 0.152.
 */
package com.wavefront.sdk.common.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public abstract class DelegatingLogger
extends Logger {
    protected final Logger delegate;

    public DelegatingLogger(Logger delegate) {
        super(delegate.getName(), null);
        this.delegate = delegate;
    }

    @Override
    public abstract void log(Level var1, String var2);

    @Override
    public void log(LogRecord logRecord) {
        if (!this.isLoggable(logRecord.getLevel())) {
            return;
        }
        logRecord.setLoggerName(this.delegate.getName());
        this.inferCaller(logRecord);
        this.delegate.log(logRecord);
    }

    void inferCaller(LogRecord logRecord) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        boolean lookingForLogger = true;
        for (StackTraceElement frame : stackTraceElements) {
            String cname = frame.getClassName();
            if (lookingForLogger) {
                if (!cname.endsWith("Logger")) continue;
                lookingForLogger = false;
                continue;
            }
            if (cname.endsWith("Logger") || cname.startsWith("java.lang.reflect.") || cname.startsWith("sun.reflect.")) continue;
            logRecord.setSourceClassName(cname);
            logRecord.setSourceMethodName(frame.getMethodName());
            return;
        }
    }
}

