/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.client.console.SyncopeConsoleSession;
import org.apache.syncope.client.console.pages.Login;
import org.apache.syncope.client.console.pages.OIDCClientBeforeLogout;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientLogin
extends WebPage {
    private static final long serialVersionUID = 8581614051773949262L;
    private static final Logger LOG = LoggerFactory.getLogger(OIDCClientLogin.class);
    private static final String OIDC_ACCESS_ERROR = "OIDC access error";

    public OIDCClientLogin(PageParameters parameters) {
        super(parameters);
        String jwt = parameters.get("oidcc4ui.jwt").toOptionalString();
        Instant jwtExpiration = (Instant)parameters.get("oidcc4ui.jwt.expiration").toOptional(Instant.class);
        if (StringUtils.isBlank((CharSequence)jwt)) {
            LOG.error("No JWT found, redirecting to default greeter");
            PageParameters loginParameters = new PageParameters();
            loginParameters.add("notificationMessage", (Object)OIDC_ACCESS_ERROR);
            loginParameters.add("notificationLevel", (Object)"error");
            this.setResponsePage(Login.class, loginParameters);
        }
        IAuthenticationStrategy strategy = this.getApplication().getSecuritySettings().getAuthenticationStrategy();
        if (SyncopeConsoleSession.get().authenticate(jwt, jwtExpiration)) {
            if (parameters.get("oidcc4ui.sloSupported").toBoolean(false)) {
                SyncopeConsoleSession.get().setAttribute("beforeLogoutPage", OIDCClientBeforeLogout.class);
            }
            this.continueToOriginalDestination();
            this.setResponsePage(this.getApplication().getHomePage());
        } else {
            PageParameters loginParameters = new PageParameters();
            loginParameters.add("notificationMessage", (Object)OIDC_ACCESS_ERROR);
            loginParameters.add("notificationLevel", (Object)"error");
            this.setResponsePage(Login.class, loginParameters);
        }
        strategy.remove();
    }
}

