/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.vk;

import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.pac4j.core.profile.Gender;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.oauth.profile.OAuth20Profile;

public class VkProfile
extends OAuth20Profile {
    private static final long serialVersionUID = -7889265305949082980L;

    public String getDisplayName() {
        return String.format("%s %s", this.getFirstName(), this.getLastName()).trim();
    }

    public String getUsername() {
        String domain = this.getDomain();
        if (domain != null && !domain.isEmpty()) {
            return domain;
        }
        return this.getId();
    }

    public URI getPictureUrl() {
        return CommonHelper.asURI((String)this.getFotoMax());
    }

    public URI getProfileUrl() {
        return CommonHelper.asURI((String)String.format("https://vk.com/id%s", this.getId()));
    }

    public String getEmail() {
        return "";
    }

    public String getFamilyName() {
        return this.getLastName();
    }

    public Gender getGender() {
        Gender gender = (Gender)this.getAttribute("sex");
        return Objects.requireNonNullElse(gender, Gender.UNSPECIFIED);
    }

    public Locale getLocale() {
        return null;
    }

    public String getLocation() {
        return null;
    }

    public String getFirstName() {
        return (String)this.getAttribute("first_name");
    }

    public String getLastName() {
        return (String)this.getAttribute("last_name");
    }

    public Date getBirthDate() {
        return (Date)this.getAttribute("bdate");
    }

    public String getFoto50() {
        return (String)this.getAttribute("photo_50");
    }

    public String getFoto100() {
        return (String)this.getAttribute("photo_100");
    }

    public String getFoto200Orig() {
        return (String)this.getAttribute("photo_200_orig");
    }

    public String getFoto200() {
        return (String)this.getAttribute("photo_200");
    }

    public String getFoto400Orig() {
        return (String)this.getAttribute("photo_400_orig");
    }

    public String getFotoMax() {
        return (String)this.getAttribute("photo_max");
    }

    public String getFotoMaxOrig() {
        return (String)this.getAttribute("photo_max_orig");
    }

    public Boolean isOnline() {
        return (Boolean)this.getAttribute("online");
    }

    public Boolean isOnlineMobile() {
        return (Boolean)this.getAttribute("online_mobile");
    }

    public String getDomain() {
        return (String)this.getAttribute("domain");
    }

    public Boolean isHasMobile() {
        return (Boolean)this.getAttribute("has_mobile");
    }

    public String getMobilePhone() {
        return (String)this.getAttribute("mobile_phone");
    }

    public String getHomePhone() {
        return (String)this.getAttribute("home_phone");
    }

    public String getSkype() {
        return (String)this.getAttribute("skype");
    }

    public String getSite() {
        return (String)this.getAttribute("site");
    }

    public Boolean isCanPost() {
        return (Boolean)this.getAttribute("can_post");
    }

    public Boolean isCanSeeAllPost() {
        return (Boolean)this.getAttribute("can_see_all_posts");
    }

    public Boolean isCanSeeAudio() {
        return (Boolean)this.getAttribute("can_see_audio");
    }

    public Boolean isCanWritePrivateMessage() {
        return (Boolean)this.getAttribute("can_write_private_message");
    }

    public String getStatus() {
        return (String)this.getAttribute("status");
    }

    public Integer getCommonCount() {
        return (Integer)this.getAttribute("common_count");
    }

    public Integer getRelation() {
        return (Integer)this.getAttribute("relation");
    }
}

