/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.dao.repo;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.syncope.core.persistence.api.dao.AnyMatchDAO;
import org.apache.syncope.core.persistence.api.dao.AnyObjectDAO;
import org.apache.syncope.core.persistence.api.dao.AnySearchDAO;
import org.apache.syncope.core.persistence.api.dao.GroupDAO;
import org.apache.syncope.core.persistence.api.dao.UserDAO;
import org.apache.syncope.core.persistence.api.entity.Any;
import org.apache.syncope.core.persistence.api.entity.DynRealm;
import org.apache.syncope.core.persistence.api.entity.Entity;
import org.apache.syncope.core.persistence.api.search.SearchCondConverter;
import org.apache.syncope.core.persistence.api.search.SearchCondVisitor;
import org.apache.syncope.core.persistence.jpa.dao.repo.DynRealmRepoExt;
import org.apache.syncope.core.persistence.jpa.entity.JPADynRealm;
import org.apache.syncope.core.provisioning.api.event.EntityLifecycleEvent;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public class DynRealmRepoExtImpl
implements DynRealmRepoExt {
    protected final ApplicationEventPublisher publisher;
    protected final UserDAO userDAO;
    protected final GroupDAO groupDAO;
    protected final AnyObjectDAO anyObjectDAO;
    protected final AnySearchDAO searchDAO;
    protected final AnyMatchDAO anyMatchDAO;
    protected final SearchCondVisitor searchCondVisitor;
    protected final EntityManager entityManager;

    public DynRealmRepoExtImpl(ApplicationEventPublisher publisher, UserDAO userDAO, GroupDAO groupDAO, AnyObjectDAO anyObjectDAO, AnySearchDAO searchDAO, AnyMatchDAO anyMatchDAO, SearchCondVisitor searchCondVisitor, EntityManager entityManager) {
        this.publisher = publisher;
        this.userDAO = userDAO;
        this.groupDAO = groupDAO;
        this.anyObjectDAO = anyObjectDAO;
        this.searchDAO = searchDAO;
        this.anyMatchDAO = anyMatchDAO;
        this.searchCondVisitor = searchCondVisitor;
        this.entityManager = entityManager;
    }

    protected List<String> clearDynMembers(DynRealm dynRealm) {
        Query find = this.entityManager.createNativeQuery("SELECT any_id FROM DynRealmMembers WHERE dynRealm_id=?");
        find.setParameter(1, (Object)dynRealm.getKey());
        List result = find.getResultList();
        List<String> cleared = result.stream().map(Object::toString).collect(Collectors.toList());
        Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=?");
        delete.setParameter(1, (Object)dynRealm.getKey());
        delete.executeUpdate();
        return cleared;
    }

    protected void notifyDynMembershipRemoval(List<String> anyKeys) {
        anyKeys.forEach(key -> {
            Optional any = this.userDAO.findById(key);
            if (any.isEmpty()) {
                any = this.groupDAO.findById(key);
            }
            if (any.isEmpty()) {
                any = this.anyObjectDAO.findById(key);
            }
            any.ifPresent(entity -> this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)entity, AuthContextUtils.getDomain())));
        });
    }

    @Override
    public DynRealm saveAndRefreshDynMemberships(DynRealm dynRealm) {
        DynRealm merged = (DynRealm)this.entityManager.merge((Object)dynRealm);
        List<String> cleared = this.clearDynMembers(merged);
        merged.getDynMemberships().stream().map(memb -> this.searchDAO.search(SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]), memb.getAnyType().getKind())).forEach(matching -> matching.forEach(any -> {
            Query insert = this.entityManager.createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
            insert.setParameter(1, (Object)any.getKey());
            insert.setParameter(2, (Object)merged.getKey());
            insert.executeUpdate();
            this.publisher.publishEvent((ApplicationEvent)new EntityLifecycleEvent((Object)this, SyncDeltaType.UPDATE, (Entity)any, AuthContextUtils.getDomain()));
            cleared.remove(any.getKey());
        }));
        this.notifyDynMembershipRemoval(cleared);
        return merged;
    }

    @Override
    public void deleteById(String key) {
        DynRealm dynRealm = (DynRealm)this.entityManager.find(JPADynRealm.class, (Object)key);
        if (dynRealm == null) {
            return;
        }
        this.notifyDynMembershipRemoval(this.clearDynMembers(dynRealm));
        this.entityManager.remove((Object)dynRealm);
    }

    @Override
    @Transactional
    public void refreshDynMemberships(Any any) {
        this.entityManager.createQuery("SELECT e FROM " + JPADynRealm.class.getSimpleName() + " e ", DynRealm.class).getResultStream().forEach(dynRealm -> dynRealm.getDynMembership(any.getType()).ifPresent(memb -> {
            boolean existing;
            boolean matches = this.anyMatchDAO.matches(any, SearchCondConverter.convert((SearchCondVisitor)this.searchCondVisitor, (String)memb.getFIQLCond(), (String[])new String[0]));
            Query query = this.entityManager.createNativeQuery("SELECT COUNT(dynRealm_id) FROM DynRealmMembers WHERE any_id=? AND dynRealm_id=?");
            query.setParameter(1, (Object)any.getKey());
            query.setParameter(2, (Object)dynRealm.getKey());
            boolean bl = existing = ((Number)query.getSingleResult()).longValue() > 0L;
            if (matches && !existing) {
                Query insert = this.entityManager.createNativeQuery("INSERT INTO DynRealmMembers VALUES(?, ?)");
                insert.setParameter(1, (Object)any.getKey());
                insert.setParameter(2, (Object)dynRealm.getKey());
                insert.executeUpdate();
            } else if (!matches && existing) {
                Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRealmMembers WHERE dynRealm_id=? AND any_id=?");
                delete.setParameter(1, (Object)dynRealm.getKey());
                delete.setParameter(2, (Object)any.getKey());
                delete.executeUpdate();
            }
        }));
    }

    @Override
    public void removeDynMemberships(String anyKey) {
        Query delete = this.entityManager.createNativeQuery("DELETE FROM DynRealmMembers WHERE any_id=?");
        delete.setParameter(1, (Object)anyKey);
        delete.executeUpdate();
    }
}

