/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.group;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.RelationshipType;
import org.apache.syncope.core.persistence.api.entity.anyobject.AnyObject;
import org.apache.syncope.core.persistence.api.entity.group.GRelationship;
import org.apache.syncope.core.persistence.api.entity.group.Group;
import org.apache.syncope.core.persistence.common.validation.RelationshipCheck;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPARelationshipType;
import org.apache.syncope.core.persistence.jpa.entity.anyobject.JPAAnyObject;
import org.apache.syncope.core.persistence.jpa.entity.group.JPAGroup;

@Entity
@Table(name="GRelationship", uniqueConstraints={@UniqueConstraint(columnNames={"type_id", "group_id", "anyObject_id"})})
@RelationshipCheck
public class JPAGRelationship
extends AbstractGeneratedKeyEntity
implements GRelationship,
PersistenceCapable {
    private static final long serialVersionUID = 6608821135023815357L;
    public static final String TABLE = "GRelationship";
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPARelationshipType type;
    @ManyToOne
    @Column(name="group_id")
    private JPAGroup leftEnd;
    @ManyToOne
    @Column(name="anyObject_id")
    private JPAAnyObject rightEnd;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public RelationshipType getType() {
        return JPAGRelationship.pcGettype(this);
    }

    public void setType(RelationshipType type) {
        if ("UMembership".equalsIgnoreCase(type.getKey()) || "AMembership".equalsIgnoreCase(type.getKey())) {
            throw new IllegalArgumentException("This is not a membership");
        }
        this.checkType(type, JPARelationshipType.class);
        JPAGRelationship.pcSettype(this, (JPARelationshipType)type);
    }

    public JPAGroup getLeftEnd() {
        return JPAGRelationship.pcGetleftEnd(this);
    }

    public void setLeftEnd(Group leftEnd) {
        this.checkType(leftEnd, JPAGroup.class);
        JPAGRelationship.pcSetleftEnd(this, (JPAGroup)leftEnd);
    }

    public AnyObject getRightEnd() {
        return JPAGRelationship.pcGetrightEnd(this);
    }

    public void setRightEnd(AnyObject rightEnd) {
        this.checkType(rightEnd, JPAAnyObject.class);
        JPAGRelationship.pcSetrightEnd(this, (JPAAnyObject)rightEnd);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractGeneratedKeyEntity.class;
        pcFieldNames = new String[]{"leftEnd", "rightEnd", "type"};
        pcFieldTypes = new Class[]{JPAGroup.class, JPAAnyObject.class, JPARelationshipType.class};
        pcFieldFlags = new byte[]{26, 26, 26};
        PCRegistry.register(JPAGRelationship.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAGRelationship", (PersistenceCapable)new JPAGRelationship());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.leftEnd = null;
        this.rightEnd = null;
        this.type = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAGRelationship jPAGRelationship = new JPAGRelationship();
        if (bl) {
            jPAGRelationship.pcClearFields();
        }
        jPAGRelationship.pcStateManager = stateManager;
        jPAGRelationship.pcCopyKeyFieldsFromObjectId(object);
        return jPAGRelationship;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAGRelationship jPAGRelationship = new JPAGRelationship();
        if (bl) {
            jPAGRelationship.pcClearFields();
        }
        jPAGRelationship.pcStateManager = stateManager;
        return jPAGRelationship;
    }

    protected static int pcGetManagedFieldCount() {
        return 3 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.leftEnd = (JPAGroup)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.rightEnd = (JPAAnyObject)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.type = (JPARelationshipType)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.leftEnd);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.rightEnd);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPAGRelationship jPAGRelationship, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAGRelationship, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.leftEnd = jPAGRelationship.leftEnd;
                return;
            }
            case 1: {
                this.rightEnd = jPAGRelationship.rightEnd;
                return;
            }
            case 2: {
                this.type = jPAGRelationship.type;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAGRelationship jPAGRelationship = (JPAGRelationship)object;
        if (jPAGRelationship.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPAGRelationship, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPAGRelationship.class;
    }

    private static final JPAGroup pcGetleftEnd(JPAGRelationship jPAGRelationship) {
        if (jPAGRelationship.pcStateManager == null) {
            return jPAGRelationship.leftEnd;
        }
        int n = pcInheritedFieldCount + 0;
        jPAGRelationship.pcStateManager.accessingField(n);
        return jPAGRelationship.leftEnd;
    }

    private static final void pcSetleftEnd(JPAGRelationship jPAGRelationship, JPAGroup jPAGroup) {
        if (jPAGRelationship.pcStateManager == null) {
            jPAGRelationship.leftEnd = jPAGroup;
            return;
        }
        jPAGRelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAGRelationship, pcInheritedFieldCount + 0, (Object)jPAGRelationship.leftEnd, (Object)jPAGroup, 0);
    }

    private static final JPAAnyObject pcGetrightEnd(JPAGRelationship jPAGRelationship) {
        if (jPAGRelationship.pcStateManager == null) {
            return jPAGRelationship.rightEnd;
        }
        int n = pcInheritedFieldCount + 1;
        jPAGRelationship.pcStateManager.accessingField(n);
        return jPAGRelationship.rightEnd;
    }

    private static final void pcSetrightEnd(JPAGRelationship jPAGRelationship, JPAAnyObject jPAAnyObject) {
        if (jPAGRelationship.pcStateManager == null) {
            jPAGRelationship.rightEnd = jPAAnyObject;
            return;
        }
        jPAGRelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAGRelationship, pcInheritedFieldCount + 1, (Object)jPAGRelationship.rightEnd, (Object)jPAAnyObject, 0);
    }

    private static final JPARelationshipType pcGettype(JPAGRelationship jPAGRelationship) {
        if (jPAGRelationship.pcStateManager == null) {
            return jPAGRelationship.type;
        }
        int n = pcInheritedFieldCount + 2;
        jPAGRelationship.pcStateManager.accessingField(n);
        return jPAGRelationship.type;
    }

    private static final void pcSettype(JPAGRelationship jPAGRelationship, JPARelationshipType jPARelationshipType) {
        if (jPAGRelationship.pcStateManager == null) {
            jPAGRelationship.type = jPARelationshipType;
            return;
        }
        jPAGRelationship.pcStateManager.settingObjectField((PersistenceCapable)jPAGRelationship, pcInheritedFieldCount + 2, (Object)jPAGRelationship.type, (Object)jPARelationshipType, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

