/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui;

import org.apache.wicket.Component;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.kendo.ui.IKendoDataSource;

public class KendoDataSource
extends Options
implements IKendoDataSource {
    private static final long serialVersionUID = 1L;
    protected static final String TYPE = "json";
    private final String name;
    protected final Options transport;

    public KendoDataSource(String name) {
        this(name, TYPE);
    }

    public KendoDataSource(Component component) {
        this(KendoDataSource.nameOf(component), TYPE);
    }

    public KendoDataSource(String name, String type) {
        this.name = ((String)Args.notNull((Object)name, (String)"name")).replace('#', '_');
        this.transport = new Options();
        this.set("sync", "function() { this.read(); }");
        this.set("error", "function (xhr, error) { var dw = Wicket.Ajax.DebugWindow; if (typeof dw !== 'undefined') { dw.logError(kendo.stringify(xhr)); } }");
        this.set("dataType", Options.asString((String)type));
    }

    public KendoDataSource(Component component, String type) {
        this(KendoDataSource.nameOf(component), type);
    }

    public String getName() {
        return "window." + this.name;
    }

    public void setTransportRead(String function) {
        this.transport.set("read", (Object)function);
    }

    public void setTransportReadUrl(CharSequence url) {
        this.transport.set("read", (Object)Options.asString((Object)url));
    }

    public void setTransportCreate(String function) {
        this.transport.set("create", (Object)function);
    }

    public void setTransportUpdate(String function) {
        this.transport.set("update", (Object)function);
    }

    public void setTransportDelete(String function) {
        this.transport.set("destroy", (Object)function);
    }

    public Options build() {
        this.set("transport", this.transport);
        return this;
    }

    @Override
    public String toScript() {
        return String.format("%s = new kendo.data.DataSource(%s);", this.getName(), this.build());
    }

    public static String nameOf(Component component) {
        return component.getMarkupId() + "_datasource";
    }

    public static String getReadCallbackFunction(CharSequence url) {
        return KendoDataSource.getReadCallbackFunction(url, false);
    }

    public static String getReadCallbackFunction(CharSequence url, boolean useCache) {
        return "function(options) { jQuery.ajax({\t\turl: '" + String.valueOf(url) + "',\t\tdata: options.data,\t\tcache: " + useCache + ",\t\tsuccess: function(result) {\t\t\toptions.success(result);\t\t},\t\terror: function(result) {\t\t\toptions.error(result);\t\t}\t});}";
    }

    public static class HierarchicalDataSource
    extends KendoDataSource {
        private static final long serialVersionUID = 1L;

        public HierarchicalDataSource(String name) {
            this(name, KendoDataSource.TYPE);
        }

        public HierarchicalDataSource(Component component) {
            super(component);
        }

        public HierarchicalDataSource(String name, String type) {
            super(name, type);
        }

        public HierarchicalDataSource(Component component, String type) {
            super(component, type);
        }

        @Override
        public String toScript() {
            return String.format("%s = new kendo.data.HierarchicalDataSource(%s);", this.getName(), this.build());
        }
    }
}

