/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.treeview;

import com.github.openjson.JSONArray;
import java.util.List;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.util.lang.Args;
import org.wicketstuff.jquery.core.behavior.AjaxCallbackBehavior;
import org.wicketstuff.kendo.ui.widget.treeview.TreeNode;
import org.wicketstuff.kendo.ui.widget.treeview.TreeNodeFactory;
import org.wicketstuff.kendo.ui.widget.treeview.TreeViewModel;

public class TreeViewModelBehavior
extends AjaxCallbackBehavior {
    private static final long serialVersionUID = 1L;
    private final TreeViewModel model;
    private final TreeNodeFactory factory;

    public TreeViewModelBehavior(TreeViewModel model, TreeNodeFactory factory) {
        this.model = model;
        this.factory = (TreeNodeFactory)Args.notNull((Object)factory, (String)"factory");
    }

    public TreeNodeFactory getFactory() {
        return this.factory;
    }

    protected String getResponse(IRequestParameters parameters) {
        int nodeId = parameters.getParameterValue("nid").toInt(0);
        JSONArray payload = new JSONArray();
        if (this.model != null) {
            this.model.setNodeId(nodeId);
            List objects = (List)this.model.getObject();
            for (int index = 0; index < objects.size(); ++index) {
                TreeNode object = (TreeNode)objects.get(index);
                payload.put((Object)this.factory.toJson(index, object));
            }
        }
        return payload.toString();
    }
}

