/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.widget.window;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.wicketstuff.jquery.core.resource.StyleSheetPackageHeaderItem;
import org.wicketstuff.kendo.ui.panel.KendoFeedbackPanel;
import org.wicketstuff.kendo.ui.widget.window.Window;
import org.wicketstuff.kendo.ui.widget.window.WindowButton;
import org.wicketstuff.kendo.ui.widget.window.WindowButtons;

public abstract class FormWindow<T>
extends Window<T> {
    private static final long serialVersionUID = 1L;
    private final Form<?> form = FormWindow.newForm("form");
    private KendoFeedbackPanel feedback;

    public FormWindow(String id, String title) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), (IModel<T>)null);
    }

    public FormWindow(String id, String title, IModel<T> model) {
        this(id, (IModel<String>)Model.of((Serializable)((Object)title)), model);
    }

    public FormWindow(String id, IModel<String> title) {
        this(id, title, (IModel<T>)null);
    }

    public FormWindow(String id, IModel<String> title, IModel<T> model) {
        super(id, title, model, WindowButtons.OK_CANCEL);
        this.add(new Component[]{this.form});
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new StyleSheetPackageHeaderItem(FormWindow.class));
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.feedback = this.newFeedbackPanel("feedback");
        this.form.add(new Component[]{this.feedback});
        this.form.add(new Component[]{this.newButtonPanel("buttons", this.getButtons())});
    }

    @Override
    protected void onOpen(IPartialPageRequestHandler handler) {
        super.onOpen(handler);
        handler.add(new Component[]{this.form});
    }

    @Override
    protected void onError(AjaxRequestTarget target, WindowButton button) {
        super.onError(target, button);
        target.add(new Component[]{this.feedback});
    }

    @Override
    protected void onSubmit(AjaxRequestTarget target, WindowButton button) {
        if (button != null) {
            if (button.match("OK")) {
                this.onSubmit(target);
            } else if (button.match("CANCEL")) {
                this.onCancel(target);
            }
        }
    }

    protected abstract void onSubmit(AjaxRequestTarget var1);

    protected void onCancel(AjaxRequestTarget target) {
    }

    @Override
    public Form<?> getForm() {
        return this.form;
    }

    private static Form<Void> newForm(String id) {
        return new Form<Void>(id){
            private static final long serialVersionUID = 1L;

            protected boolean wantSubmitOnParentFormSubmit() {
                return false;
            }
        };
    }

    protected KendoFeedbackPanel newFeedbackPanel(String id) {
        return new KendoFeedbackPanel(id, (MarkupContainer)this);
    }
}

