/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.examples;

import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.schema.EntryValidator;
import com.unboundid.ldif.LDIFReaderEntryTranslator;
import com.unboundid.ldif.LDIFWriter;
import com.unboundid.util.Debug;
import com.unboundid.util.LDAPCommandLineTool;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.Argument;
import com.unboundid.util.args.ArgumentException;
import com.unboundid.util.args.ArgumentParser;
import com.unboundid.util.args.BooleanArgument;
import com.unboundid.util.args.FileArgument;
import com.unboundid.util.args.IntegerArgument;
import com.unboundid.util.args.StringArgument;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class ValidateLDIF
extends LDAPCommandLineTool
implements LDIFReaderEntryTranslator {
    @NotNull
    private static final String EOL = StaticUtils.getSystemProperty("line.separator", "\n");
    @Nullable
    private BooleanArgument ignoreDuplicateValues;
    @Nullable
    private BooleanArgument ignoreUndefinedObjectClasses;
    @Nullable
    private BooleanArgument ignoreUndefinedAttributes;
    @Nullable
    private BooleanArgument ignoreMalformedDNs;
    @Nullable
    private BooleanArgument ignoreMissingRDNValues;
    @Nullable
    private BooleanArgument ignoreMissingSuperiorObjectClasses;
    @Nullable
    private BooleanArgument ignoreStructuralObjectClasses;
    @Nullable
    private BooleanArgument ignoreProhibitedObjectClasses;
    @Nullable
    private BooleanArgument ignoreProhibitedAttributes;
    @Nullable
    private BooleanArgument ignoreMissingAttributes;
    @Nullable
    private BooleanArgument ignoreSingleValuedAttributes;
    @Nullable
    private BooleanArgument ignoreAttributeSyntax;
    @Nullable
    private BooleanArgument ignoreNameForms;
    @Nullable
    private BooleanArgument isCompressed;
    @Nullable
    private FileArgument schemaDirectory;
    @Nullable
    private FileArgument ldifFile;
    @Nullable
    private FileArgument rejectFile;
    @Nullable
    private FileArgument encryptionPassphraseFile;
    @Nullable
    private IntegerArgument numThreads;
    @Nullable
    private StringArgument ignoreSyntaxViolationsForAttribute;
    @NotNull
    private final AtomicLong entriesProcessed = new AtomicLong(0L);
    @NotNull
    private final AtomicLong malformedEntries = new AtomicLong(0L);
    @Nullable
    private EntryValidator entryValidator;
    @Nullable
    private LDIFWriter rejectWriter;

    public static void main(@NotNull String[] args) {
        ResultCode resultCode = ValidateLDIF.main(args, System.out, System.err);
        if (resultCode != ResultCode.SUCCESS) {
            System.exit(resultCode.intValue());
        }
    }

    @NotNull
    public static ResultCode main(@NotNull String[] args, @Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        ValidateLDIF validateLDIF = new ValidateLDIF(outStream, errStream);
        return validateLDIF.runTool(args);
    }

    public ValidateLDIF(@Nullable OutputStream outStream, @Nullable OutputStream errStream) {
        super(outStream, errStream);
    }

    @Override
    @NotNull
    public String getToolName() {
        return "validate-ldif";
    }

    @Override
    @NotNull
    public String getToolDescription() {
        return "Validate the contents of an LDIF file against the server schema.";
    }

    @Override
    @NotNull
    public String getToolVersion() {
        return "6.0.11";
    }

    @Override
    public boolean supportsInteractiveMode() {
        return true;
    }

    @Override
    public boolean defaultsToInteractiveMode() {
        return true;
    }

    @Override
    protected boolean supportsOutputFile() {
        return true;
    }

    @Override
    protected boolean defaultToPromptForBindPassword() {
        return true;
    }

    @Override
    public boolean supportsPropertiesFile() {
        return true;
    }

    @Override
    protected boolean includeAlternateLongIdentifiers() {
        return true;
    }

    @Override
    protected boolean supportsSSLDebugging() {
        return true;
    }

    @Override
    public void addNonLDAPArguments(@NotNull ArgumentParser parser) throws ArgumentException {
        String description = "The path to the LDIF file to process.  The tool will automatically attempt to detect whether the file is encrypted or compressed.";
        this.ldifFile = new FileArgument(Character.valueOf('f'), "ldifFile", true, 1, "{path}", description, true, true, true, false);
        this.ldifFile.addLongIdentifier("ldif-file", true);
        parser.addArgument(this.ldifFile);
        description = "Indicates that the specified LDIF file is compressed using gzip compression.";
        this.isCompressed = new BooleanArgument(Character.valueOf('c'), "isCompressed", description);
        this.isCompressed.addLongIdentifier("is-compressed", true);
        this.isCompressed.setHidden(true);
        parser.addArgument(this.isCompressed);
        description = "Indicates that the specified LDIF file is encrypted and that the encryption passphrase is contained in the specified file.  If the LDIF data is encrypted and this argument is not provided, then the tool will interactively prompt for the encryption passphrase.";
        this.encryptionPassphraseFile = new FileArgument(null, "encryptionPassphraseFile", false, 1, null, description, true, true, true, false);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-passphrase-file", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryptionPasswordFile", true);
        this.encryptionPassphraseFile.addLongIdentifier("encryption-password-file", true);
        parser.addArgument(this.encryptionPassphraseFile);
        description = "The path to the file to which rejected entries should be written.";
        this.rejectFile = new FileArgument(Character.valueOf('R'), "rejectFile", false, 1, "{path}", description, false, true, true, false);
        this.rejectFile.addLongIdentifier("reject-file", true);
        parser.addArgument(this.rejectFile);
        description = "The path to a directory containing one or more LDIF files with the schema information to use.  If this is provided, then no LDAP communication will be performed.";
        this.schemaDirectory = new FileArgument(null, "schemaDirectory", false, 1, "{path}", description, true, true, false, true);
        this.schemaDirectory.addLongIdentifier("schema-directory", true);
        parser.addArgument(this.schemaDirectory);
        description = "The number of threads to use when processing the LDIF file.";
        this.numThreads = new IntegerArgument(Character.valueOf('t'), "numThreads", true, 1, "{num}", description, 1, Integer.MAX_VALUE, 1);
        this.numThreads.addLongIdentifier("num-threads", true);
        parser.addArgument(this.numThreads);
        description = "Ignore validation failures due to entries containing duplicate values for the same attribute.";
        this.ignoreDuplicateValues = new BooleanArgument(null, "ignoreDuplicateValues", description);
        this.ignoreDuplicateValues.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreDuplicateValues.addLongIdentifier("ignore-duplicate-values", true);
        parser.addArgument(this.ignoreDuplicateValues);
        description = "Ignore validation failures due to object classes not defined in the schema.";
        this.ignoreUndefinedObjectClasses = new BooleanArgument(null, "ignoreUndefinedObjectClasses", description);
        this.ignoreUndefinedObjectClasses.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreUndefinedObjectClasses.addLongIdentifier("ignore-undefined-object-classes", true);
        parser.addArgument(this.ignoreUndefinedObjectClasses);
        description = "Ignore validation failures due to attributes not defined in the schema.";
        this.ignoreUndefinedAttributes = new BooleanArgument(null, "ignoreUndefinedAttributes", description);
        this.ignoreUndefinedAttributes.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreUndefinedAttributes.addLongIdentifier("ignore-undefined-attributes", true);
        parser.addArgument(this.ignoreUndefinedAttributes);
        description = "Ignore validation failures due to entries with malformed DNs.";
        this.ignoreMalformedDNs = new BooleanArgument(null, "ignoreMalformedDNs", description);
        this.ignoreMalformedDNs.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreMalformedDNs.addLongIdentifier("ignore-malformed-dns", true);
        parser.addArgument(this.ignoreMalformedDNs);
        description = "Ignore validation failures due to entries with RDN attribute values that are missing from the set of entry attributes.";
        this.ignoreMissingRDNValues = new BooleanArgument(null, "ignoreMissingRDNValues", description);
        this.ignoreMissingRDNValues.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreMissingRDNValues.addLongIdentifier("ignore-missing-rdn-values", true);
        parser.addArgument(this.ignoreMissingRDNValues);
        description = "Ignore validation failures due to entries without exactly structural object class.";
        this.ignoreStructuralObjectClasses = new BooleanArgument(null, "ignoreStructuralObjectClasses", description);
        this.ignoreStructuralObjectClasses.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreStructuralObjectClasses.addLongIdentifier("ignore-structural-object-classes", true);
        parser.addArgument(this.ignoreStructuralObjectClasses);
        description = "Ignore validation failures due to entries with object classes that are not allowed.";
        this.ignoreProhibitedObjectClasses = new BooleanArgument(null, "ignoreProhibitedObjectClasses", description);
        this.ignoreProhibitedObjectClasses.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreProhibitedObjectClasses.addLongIdentifier("ignore-prohibited-object-classes", true);
        parser.addArgument(this.ignoreProhibitedObjectClasses);
        description = "Ignore validation failures due to entries that are one or more superior object classes.";
        this.ignoreMissingSuperiorObjectClasses = new BooleanArgument(null, "ignoreMissingSuperiorObjectClasses", description);
        this.ignoreMissingSuperiorObjectClasses.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreMissingSuperiorObjectClasses.addLongIdentifier("ignore-missing-superior-object-classes", true);
        parser.addArgument(this.ignoreMissingSuperiorObjectClasses);
        description = "Ignore validation failures due to entries with attributes that are not allowed.";
        this.ignoreProhibitedAttributes = new BooleanArgument(null, "ignoreProhibitedAttributes", description);
        this.ignoreProhibitedAttributes.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreProhibitedAttributes.addLongIdentifier("ignore-prohibited-attributes", true);
        parser.addArgument(this.ignoreProhibitedAttributes);
        description = "Ignore validation failures due to entries missing required attributes.";
        this.ignoreMissingAttributes = new BooleanArgument(null, "ignoreMissingAttributes", description);
        this.ignoreMissingAttributes.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreMissingAttributes.addLongIdentifier("ignore-missing-attributes", true);
        parser.addArgument(this.ignoreMissingAttributes);
        description = "Ignore validation failures due to entries with multiple values for single-valued attributes.";
        this.ignoreSingleValuedAttributes = new BooleanArgument(null, "ignoreSingleValuedAttributes", description);
        this.ignoreSingleValuedAttributes.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreSingleValuedAttributes.addLongIdentifier("ignore-single-valued-attributes", true);
        parser.addArgument(this.ignoreSingleValuedAttributes);
        description = "Ignore validation failures due to entries with attribute values that violate their associated syntax.  If this is provided, then no attribute syntax violations will be flagged.  If this is not provided, then all attribute syntax violations will be flagged except for violations in those attributes excluded by the --ignoreSyntaxViolationsForAttribute argument.";
        this.ignoreAttributeSyntax = new BooleanArgument(null, "ignoreAttributeSyntax", description);
        this.ignoreAttributeSyntax.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreAttributeSyntax.addLongIdentifier("ignore-attribute-syntax", true);
        parser.addArgument(this.ignoreAttributeSyntax);
        description = "The name or OID of an attribute for which to ignore validation failures due to violations of the associated attribute syntax.  This argument can only be used if the --ignoreAttributeSyntax argument is not provided.";
        this.ignoreSyntaxViolationsForAttribute = new StringArgument(null, "ignoreSyntaxViolationsForAttribute", false, 0, "{attr}", description);
        this.ignoreSyntaxViolationsForAttribute.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreSyntaxViolationsForAttribute.addLongIdentifier("ignore-syntax-violations-for-attribute", true);
        parser.addArgument(this.ignoreSyntaxViolationsForAttribute);
        description = "Ignore validation failures due to entries with RDNs that violate the associated name form definition.";
        this.ignoreNameForms = new BooleanArgument(null, "ignoreNameForms", description);
        this.ignoreNameForms.setArgumentGroupName("Validation Strictness Arguments");
        this.ignoreNameForms.addLongIdentifier("ignore-name-forms", true);
        parser.addArgument(this.ignoreNameForms);
        parser.addExclusiveArgumentSet(this.ignoreAttributeSyntax, this.ignoreSyntaxViolationsForAttribute, new Argument[0]);
    }

    /*
     * Exception decompiling
     */
    @Override
    @NotNull
    public ResultCode doToolProcessing() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [13[TRYBLOCK]], but top level block is 38[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Entry translate(@NotNull Entry entry, long firstLineNumber) {
        long numEntries;
        ArrayList<String> invalidReasons = new ArrayList<String>(5);
        if (!this.entryValidator.entryIsValid(entry, invalidReasons) && this.rejectWriter != null) {
            ValidateLDIF validateLDIF = this;
            synchronized (validateLDIF) {
                try {
                    this.rejectWriter.writeEntry(entry, ValidateLDIF.listToString(invalidReasons));
                }
                catch (IOException ioe) {
                    Debug.debugException(ioe);
                }
            }
        }
        if ((numEntries = this.entriesProcessed.incrementAndGet()) % 1000L == 0L) {
            this.out("Processed ", numEntries, " entries.");
        }
        return null;
    }

    @Nullable
    private static String listToString(@Nullable List<String> l) {
        if (l == null || l.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iterator = l.iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(EOL);
        }
        return buffer.toString();
    }

    @Override
    @NotNull
    public LinkedHashMap<String[], String> getExampleUsages() {
        LinkedHashMap<String[], String> examples = new LinkedHashMap<String[], String>(StaticUtils.computeMapCapacity(2));
        String[] args = new String[]{"--hostname", "server.example.com", "--port", "389", "--ldifFile", "data.ldif", "--rejectFile", "rejects.ldif", "--numThreads", "4"};
        String description = "Validate the contents of the 'data.ldif' file using the schema defined in the specified directory server using four concurrent threads.  All types of validation will be performed, and information about any errors will be written to the 'rejects.ldif' file.";
        examples.put(args, description);
        args = new String[]{"--schemaDirectory", "/ds/config/schema", "--ldifFile", "data.ldif", "--rejectFile", "rejects.ldif", "--ignoreStructuralObjectClasses", "--ignoreAttributeSyntax"};
        description = "Validate the contents of the 'data.ldif' file using the schema defined in LDIF files contained in the /ds/config/schema directory using a single thread.  Any errors resulting from entries that do not have exactly one structural object class or from values which violate the syntax for their associated attribute types will be ignored.  Information about any other failures will be written to the 'rejects.ldif' file.";
        examples.put(args, description);
        return examples;
    }

    @Nullable
    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }
}

