/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(value="openfga")
public class OpenFGAProperties
implements InitializingBean {
    private String apiUrl;
    private String apiToken;
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration readTimeout = Duration.ofSeconds(10L);
    @DurationUnit(value=ChronoUnit.SECONDS)
    private Duration connectTimeout = Duration.ofSeconds(10L);

    private static void assertPositive(Duration duration, String fieldName) {
        if (duration != null && duration.isNegative()) {
            throw new IllegalStateException("%s must be positive".formatted(fieldName));
        }
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public void setApiUrl(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    public String getApiToken() {
        return this.apiToken;
    }

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void afterPropertiesSet() {
        OpenFGAProperties.assertPositive(this.readTimeout, "readTimeout");
        OpenFGAProperties.assertPositive(this.connectTimeout, "connectTimeout");
    }
}

