/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.core.profile.converter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import lombok.Generated;
import org.pac4j.core.profile.converter.AbstractAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateConverter
extends AbstractAttributeConverter {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DateConverter.class);
    protected String format;
    protected Locale locale;

    public DateConverter() {
        this(DateTimeFormatter.ISO_LOCAL_DATE_TIME.toString());
    }

    public DateConverter(String format) {
        super(Date.class);
        this.format = format;
    }

    public DateConverter(String format, Locale locale) {
        this(format);
        this.locale = locale;
    }

    @Override
    protected Date internalConvert(Object attribute) {
        if (attribute instanceof String) {
            String s = (String)attribute;
            SimpleDateFormat simpleDateFormat = this.locale == null ? new SimpleDateFormat(this.format) : new SimpleDateFormat(this.format, this.locale);
            try {
                return simpleDateFormat.parse(s);
            }
            catch (ParseException e) {
                LOGGER.error("parse exception on {} with format: {} and locale: {}", new Object[]{s, this.format, this.locale, e});
            }
        }
        return null;
    }
}

