/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.pm.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.AuthenticationBuilder;
import org.apereo.cas.authentication.AuthenticationPostProcessor;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.credential.UsernamePasswordCredential;
import org.apereo.cas.configuration.model.core.authentication.passwordsync.RestfulPasswordSynchronizationProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class RestfulPasswordSynchronizationAuthenticationPostProcessor
implements AuthenticationPostProcessor {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestfulPasswordSynchronizationAuthenticationPostProcessor.class);
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(false).build().toObjectMapper();
    private final ExecutorService executorService = Executors.newVirtualThreadPerTaskExecutor();
    private final RestfulPasswordSynchronizationProperties properties;

    public void process(AuthenticationBuilder builder, AuthenticationTransaction transaction) {
        if (this.properties.isAsynchronous()) {
            this.executorService.execute(() -> this.synchronize(transaction));
        } else {
            this.synchronize(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronize(AuthenticationTransaction transaction) {
        HttpResponse response = null;
        try {
            UsernamePasswordCredential primaryCredential = (UsernamePasswordCredential)transaction.getPrimaryCredential().get();
            String entity = MAPPER.writeValueAsString(Map.of("username", primaryCredential.getId(), "password", primaryCredential.toPassword()));
            Map headers = CollectionUtils.wrap((String)"Content-Type", (Object)"application/json");
            headers.putAll(this.properties.getHeaders());
            HttpExecutionRequest exec = HttpExecutionRequest.builder().url(this.properties.getUrl()).basicAuthPassword(this.properties.getBasicAuthUsername()).basicAuthUsername(this.properties.getBasicAuthPassword()).method(HttpMethod.POST).entity(entity).headers(headers).build();
            response = HttpUtils.execute((HttpExecutionRequest)exec);
            HttpUtils.close((HttpResponse)response);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        finally {
            HttpUtils.close(response);
        }
    }

    public boolean supports(Credential credential) throws Throwable {
        return credential instanceof UsernamePasswordCredential;
    }

    @Generated
    public RestfulPasswordSynchronizationAuthenticationPostProcessor(RestfulPasswordSynchronizationProperties properties) {
        this.properties = properties;
    }
}

