/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.cxf;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.ext.scimv2.api.data.SCIMGroup;
import org.apache.syncope.ext.scimv2.api.data.SCIMUser;

@Provider
public class AddETagFilter
implements ContainerResponseFilter {
    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext resCtx) {
        Object object;
        if (resCtx.getEntityTag() == null && (object = resCtx.getEntity()) instanceof SCIMUser) {
            String etagValue;
            SCIMUser scimUser = (SCIMUser)object;
            OffsetDateTime lastModified = scimUser.getMeta().getLastModified();
            Object object2 = resCtx.getEntity();
            if (object2 instanceof SCIMGroup) {
                SCIMGroup scimGroup = (SCIMGroup)object2;
                lastModified = scimGroup.getMeta().getLastModified();
            }
            if (lastModified != null && StringUtils.isNotBlank((CharSequence)(etagValue = String.valueOf(lastModified.toInstant().toEpochMilli())))) {
                resCtx.getHeaders().add((Object)"ETag", (Object)RuntimeDelegate.getInstance().createHeaderDelegate(EntityTag.class).toString((Object)new EntityTag(etagValue)));
            }
        }
    }
}

