/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.endpoint;

import org.springframework.boot.actuate.endpoint.Access;
import org.springframework.boot.actuate.endpoint.EndpointAccessResolver;
import org.springframework.boot.actuate.endpoint.EndpointId;
import org.springframework.boot.actuate.endpoint.Operation;
import org.springframework.boot.actuate.endpoint.OperationType;

@FunctionalInterface
public interface OperationFilter<O extends Operation> {
    public boolean match(O var1, EndpointId var2, Access var3);

    public static <O extends Operation> OperationFilter<O> byAccess(EndpointAccessResolver accessResolver) {
        return (operation, endpointId, defaultAccess) -> {
            Access access = accessResolver.accessFor(endpointId, defaultAccess);
            return switch (access) {
                default -> throw new IncompatibleClassChangeError();
                case Access.NONE -> false;
                case Access.READ_ONLY -> {
                    if (operation.getType() == OperationType.READ) {
                        yield true;
                    }
                    yield false;
                }
                case Access.UNRESTRICTED -> true;
            };
        };
    }
}

