/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.persistence.entity.data.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flowable.common.engine.impl.cfg.IdGenerator;
import org.flowable.common.engine.impl.db.AbstractDataManager;
import org.flowable.common.engine.impl.db.ListQueryParameterObject;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.HistoricTaskInstanceQueryImpl;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntity;
import org.flowable.task.service.impl.persistence.entity.HistoricTaskInstanceEntityImpl;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.data.HistoricTaskInstanceDataManager;

public class MybatisHistoricTaskInstanceDataManager
extends AbstractDataManager<HistoricTaskInstanceEntity>
implements HistoricTaskInstanceDataManager {
    protected TaskServiceConfiguration taskServiceConfiguration;

    public MybatisHistoricTaskInstanceDataManager(TaskServiceConfiguration taskServiceConfiguration) {
        this.taskServiceConfiguration = taskServiceConfiguration;
    }

    public Class<? extends HistoricTaskInstanceEntity> getManagedEntityClass() {
        return HistoricTaskInstanceEntityImpl.class;
    }

    public HistoricTaskInstanceEntity create() {
        return new HistoricTaskInstanceEntityImpl();
    }

    @Override
    public HistoricTaskInstanceEntity create(TaskEntity task) {
        return new HistoricTaskInstanceEntityImpl(task);
    }

    @Override
    public List<HistoricTaskInstanceEntity> findHistoricTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectHistoricTasksByParentTaskId", (Object)parentTaskId);
    }

    @Override
    public List<String> findHistoricTaskIdsByParentTaskIds(Collection<String> parentTaskIds) {
        return this.getDbSqlSession().selectList("selectHistoricTaskIdsByParentTaskIds", (Object)this.createSafeInValuesList(parentTaskIds));
    }

    @Override
    public List<HistoricTaskInstanceEntity> findHistoricTasksByProcessInstanceId(String processInstanceId) {
        return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByProcessInstanceId", (Object)processInstanceId);
    }

    @Override
    public List<String> findHistoricTaskIdsForProcessInstanceIds(Collection<String> processInstanceIds) {
        return this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsForProcessInstanceIds", (Object)this.createSafeInValuesList(processInstanceIds));
    }

    @Override
    public List<String> findHistoricTaskIdsForScopeIdsAndScopeType(Collection<String> scopeIds, String scopeType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("scopeIds", this.createSafeInValuesList(scopeIds));
        params.put("scopeType", scopeType);
        return this.getDbSqlSession().selectList("selectHistoricTaskInstanceIdsForScopeIdsAndScopeType", params);
    }

    @Override
    public long findHistoricTaskInstanceCountByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        this.setSafeInValueLists(historicTaskInstanceQuery);
        return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByQueryCriteria", (Object)historicTaskInstanceQuery);
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        this.setSafeInValueLists(historicTaskInstanceQuery);
        return this.getDbSqlSession().selectList("selectHistoricTaskInstancesByQueryCriteria", (ListQueryParameterObject)historicTaskInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesAndRelatedEntitiesByQueryCriteria(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        this.setSafeInValueLists(historicTaskInstanceQuery);
        return this.getDbSqlSession().selectList("selectHistoricTaskInstancesWithRelatedEntitiesByQueryCriteria", (ListQueryParameterObject)historicTaskInstanceQuery, this.getManagedEntityClass());
    }

    @Override
    public List<HistoricTaskInstance> findHistoricTaskInstancesByNativeQuery(Map<String, Object> parameterMap) {
        return this.getDbSqlSession().selectListWithRawParameter("selectHistoricTaskInstanceByNativeQuery", parameterMap);
    }

    @Override
    public long findHistoricTaskInstanceCountByNativeQuery(Map<String, Object> parameterMap) {
        return (Long)this.getDbSqlSession().selectOne("selectHistoricTaskInstanceCountByNativeQuery", parameterMap);
    }

    @Override
    public void deleteHistoricTaskInstances(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        this.getDbSqlSession().delete("bulkDeleteHistoricTaskInstances", (Object)historicTaskInstanceQuery, HistoricTaskInstanceEntityImpl.class);
    }

    @Override
    public void bulkDeleteHistoricTaskInstancesForIds(Collection<String> taskIds) {
        this.getDbSqlSession().delete("bulkDeleteHistoricTaskInstancesForIds", (Object)this.createSafeInValuesList(taskIds), HistoricTaskInstanceEntityImpl.class);
    }

    @Override
    public void deleteHistoricTaskInstancesForNonExistingProcessInstances() {
        this.getDbSqlSession().delete("bulkDeleteHistoricTaskInstancesForNonExistingProcessInstances", null, HistoricTaskInstanceEntityImpl.class);
    }

    @Override
    public void deleteHistoricTaskInstancesForNonExistingCaseInstances() {
        this.getDbSqlSession().delete("bulkDeleteHistoricTaskInstancesForNonExistingCaseInstances", null, HistoricTaskInstanceEntityImpl.class);
    }

    protected IdGenerator getIdGenerator() {
        return this.taskServiceConfiguration.getIdGenerator();
    }

    protected void setSafeInValueLists(HistoricTaskInstanceQueryImpl historicTaskInstanceQuery) {
        if (historicTaskInstanceQuery.getCandidateGroups() != null) {
            historicTaskInstanceQuery.setSafeCandidateGroups(this.createSafeInValuesList(historicTaskInstanceQuery.getCandidateGroups()));
        }
        if (historicTaskInstanceQuery.getInvolvedGroups() != null) {
            historicTaskInstanceQuery.setSafeInvolvedGroups(this.createSafeInValuesList(historicTaskInstanceQuery.getInvolvedGroups()));
        }
        if (historicTaskInstanceQuery.getOrQueryObjects() != null && !historicTaskInstanceQuery.getOrQueryObjects().isEmpty()) {
            for (HistoricTaskInstanceQueryImpl orHistoricTaskInstanceQuery : historicTaskInstanceQuery.getOrQueryObjects()) {
                this.setSafeInValueLists(orHistoricTaskInstanceQuery);
            }
        }
    }
}

