/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.cmd.methods;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.tirasa.connid.bundles.cmd.CmdConfiguration;
import net.tirasa.connid.bundles.cmd.CmdConnection;
import org.identityconnectors.common.Pair;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.common.security.SecurityUtil;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;

public abstract class CmdExec {
    private static final Log LOG = Log.getLog(CmdExec.class);
    protected final ObjectClass oc;
    protected final CmdConfiguration cmdConfiguration;

    public CmdExec(ObjectClass oc, CmdConfiguration cmdConfiguration) {
        this.oc = oc;
        this.cmdConfiguration = cmdConfiguration;
    }

    protected Process exec(String path, List<Pair<String, String>> env) {
        try {
            return CmdConnection.openConnection().execute(path, env);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error executing script: " + path, new Object[0]);
            throw new ConnectorException((Throwable)e);
        }
    }

    protected List<Pair<String, String>> createEnv(Set<Attribute> attrs, CmdConfiguration cmdConfiguration) {
        return this.createEnv(attrs, null, cmdConfiguration);
    }

    protected List<Pair<String, String>> createEnv(Set<Attribute> attrs, Uid uid, CmdConfiguration cmdConfiguration) {
        ArrayList<Pair<String, String>> env = new ArrayList<Pair<String, String>>();
        LOG.ok("Creating environment with:", new Object[0]);
        if (this.oc != null) {
            LOG.ok("OBJECT_CLASS: {0}", new Object[]{this.oc.getObjectClassValue()});
            env.add((Pair<String, String>)new Pair((Object)"OBJECT_CLASS", (Object)this.oc.getObjectClassValue()));
        }
        for (Attribute attr : attrs) {
            if (attr.getValue() == null || attr.getValue().isEmpty()) continue;
            LOG.ok("Environment variable {0}: {1}", new Object[]{attr.getName(), attr.getValue().get(0)});
            if (OperationalAttributes.PASSWORD_NAME.equals(attr.getName())) {
                GuardedString gpasswd = AttributeUtil.getPasswordValue(attrs);
                if (gpasswd == null) continue;
                env.add((Pair<String, String>)new Pair((Object)OperationalAttributes.PASSWORD_NAME, (Object)SecurityUtil.decrypt((GuardedString)gpasswd)));
                continue;
            }
            env.add((Pair<String, String>)new Pair((Object)attr.getName(), (Object)StringUtil.join((Object[])attr.getValue().toArray(), (char)',')));
        }
        if (cmdConfiguration.isServerInfoEnv()) {
            env.addAll(this.getConfigurationEnvs(cmdConfiguration));
        }
        if (uid != null && AttributeUtil.find((String)Uid.NAME, attrs) == null) {
            LOG.ok("Environment variable {0}: {1}", new Object[]{Uid.NAME, uid.getUidValue()});
            env.add((Pair<String, String>)new Pair((Object)Uid.NAME, (Object)uid.getUidValue()));
        }
        return env;
    }

    protected List<Pair<String, String>> getConfigurationEnvs(CmdConfiguration cmdConfiguration) {
        ArrayList<Pair<String, String>> confEnvs = new ArrayList<Pair<String, String>>();
        LOG.ok("Creating configuration environment with:", new Object[0]);
        if (StringUtil.isNotEmpty((String)cmdConfiguration.getHost())) {
            confEnvs.add(new Pair((Object)"CMD_HOST", (Object)cmdConfiguration.getHost()));
        }
        if (StringUtil.isNotEmpty((String)cmdConfiguration.getPort())) {
            confEnvs.add(new Pair((Object)"CMD_PORT", (Object)cmdConfiguration.getPort()));
        }
        if (StringUtil.isNotEmpty((String)cmdConfiguration.getUser())) {
            confEnvs.add((Pair<String, String>)new Pair((Object)"CMD_USER", (Object)cmdConfiguration.getUser()));
        }
        if (StringUtil.isNotEmpty((String)cmdConfiguration.getPrivateKeyPath())) {
            confEnvs.add((Pair<String, String>)new Pair((Object)"CMD_PRIVATE_KEY_PATH", (Object)cmdConfiguration.getPrivateKeyPath()));
        }
        return confEnvs;
    }

    protected void waitFor(Process proc) {
        try {
            proc.waitFor();
            LOG.info("Process ended", new Object[0]);
        }
        catch (InterruptedException e) {
            LOG.error((Throwable)e, "Error waiting for termination", new Object[0]);
        }
    }
}

