/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InetAddressUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(InetAddressUtils.class);
    private static final String CAS_SERVER_HOST_NAME = (String)FunctionUtils.doAndHandle(() -> {
        String hostName = InetAddress.getLocalHost().getHostName();
        int index = hostName.indexOf(46);
        return index > 0 ? hostName.substring(0, index) : hostName;
    }, throwable -> "unknown").get();

    public static InetAddress getByName(String urlAddr) {
        return (InetAddress)FunctionUtils.doAndHandle(() -> {
            URL url = new URI(urlAddr).toURL();
            return InetAddress.getAllByName(url.getHost())[0];
        }, e -> {
            LOGGER.trace("Host name could not be determined automatically.", e);
            return null;
        }).get();
    }

    public static String getCasServerHostName() {
        return CAS_SERVER_HOST_NAME;
    }

    public static String getCasServerHostAddress(String name) {
        return (String)Unchecked.supplier(() -> {
            InetAddress host = InetAddressUtils.getByName(name);
            return Optional.ofNullable(host).map(InetAddress::getHostAddress).orElse(null);
        }).get();
    }

    @Generated
    private InetAddressUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

