/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.oauthbearer;

import java.util.HashMap;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerExtensionsValidatorCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OAuthBearerExtensionsValidatorCallbackTest {
    private static final OAuthBearerToken TOKEN = new OAuthBearerTokenMock();

    @Test
    public void testValidatedExtensionsAreReturned() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        Assertions.assertTrue((boolean)callback.validatedExtensions().isEmpty());
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        callback.valid("hello");
        Assertions.assertFalse((boolean)callback.validatedExtensions().isEmpty());
        Assertions.assertEquals((Object)"bye", callback.validatedExtensions().get("hello"));
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
    }

    @Test
    public void testInvalidExtensionsAndErrorMessagesAreReturned() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        Assertions.assertTrue((boolean)callback.validatedExtensions().isEmpty());
        Assertions.assertTrue((boolean)callback.invalidExtensions().isEmpty());
        callback.error("hello", "error");
        Assertions.assertFalse((boolean)callback.invalidExtensions().isEmpty());
        Assertions.assertEquals((Object)"error", callback.invalidExtensions().get("hello"));
        Assertions.assertTrue((boolean)callback.validatedExtensions().isEmpty());
    }

    @Test
    public void testUnvalidatedExtensionsAreIgnored() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("valid", "valid");
        extensions.put("error", "error");
        extensions.put("nothing", "nothing");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        callback.error("error", "error");
        callback.valid("valid");
        Assertions.assertFalse((boolean)callback.validatedExtensions().containsKey("nothing"));
        Assertions.assertFalse((boolean)callback.invalidExtensions().containsKey("nothing"));
        Assertions.assertEquals((Object)"nothing", callback.ignoredExtensions().get("nothing"));
    }

    @Test
    public void testCannotValidateExtensionWhichWasNotGiven() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        extensions.put("hello", "bye");
        OAuthBearerExtensionsValidatorCallback callback = new OAuthBearerExtensionsValidatorCallback(TOKEN, new SaslExtensions(extensions));
        Assertions.assertThrows(IllegalArgumentException.class, () -> callback.valid("???"));
    }
}

