/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.flowable.engine.InternalProcessLocalizationManager;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.context.BpmnOverrideContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.engine.runtime.ProcessInstance;

public class DefaultProcessLocalizationManager
implements InternalProcessLocalizationManager {
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public DefaultProcessLocalizationManager(ProcessEngineConfigurationImpl processEngineConfiguration) {
        this.processEngineConfiguration = processEngineConfiguration;
    }

    @Override
    public void localize(ProcessInstance processInstance, String locale, boolean withLocalizationFallback) {
        ObjectNode languageNode;
        String processDefinitionId;
        ExecutionEntity processInstanceExecution = (ExecutionEntity)processInstance;
        processInstanceExecution.setLocalizedName(null);
        processInstanceExecution.setLocalizedDescription(null);
        if (locale != null && (processDefinitionId = processInstanceExecution.getProcessDefinitionId()) != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(locale, processInstanceExecution.getProcessDefinitionKey(), processDefinitionId, withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                processInstanceExecution.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                processInstanceExecution.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }

    @Override
    public void localize(HistoricProcessInstance historicProcessInstance, String locale, boolean withLocalizationFallback) {
        ObjectNode languageNode;
        String processDefinitionId;
        HistoricProcessInstanceEntity processInstanceEntity = (HistoricProcessInstanceEntity)historicProcessInstance;
        processInstanceEntity.setLocalizedName(null);
        processInstanceEntity.setLocalizedDescription(null);
        if (locale != null && (processDefinitionId = processInstanceEntity.getProcessDefinitionId()) != null && (languageNode = BpmnOverrideContext.getLocalizationElementProperties(locale, processInstanceEntity.getProcessDefinitionKey(), processDefinitionId, withLocalizationFallback)) != null) {
            JsonNode languageDescriptionNode;
            JsonNode languageNameNode = languageNode.get("name");
            if (languageNameNode != null && !languageNameNode.isNull()) {
                processInstanceEntity.setLocalizedName(languageNameNode.asText());
            }
            if ((languageDescriptionNode = languageNode.get("description")) != null && !languageDescriptionNode.isNull()) {
                processInstanceEntity.setLocalizedDescription(languageDescriptionNode.asText());
            }
        }
    }
}

