/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.MatchBehavior;
import org.passay.PasswordData;
import org.passay.PasswordUtils;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultMetadata;

public class AllowedCharacterRule
implements Rule {
    public static final String ERROR_CODE = "ALLOWED_CHAR";
    protected boolean reportAllFailures;
    private final char[] allowedCharacters;
    private final MatchBehavior matchBehavior;

    public AllowedCharacterRule(char[] c) {
        this(c, MatchBehavior.Contains, true);
    }

    public AllowedCharacterRule(char[] c, MatchBehavior behavior) {
        this(c, behavior, true);
    }

    public AllowedCharacterRule(char[] c, boolean reportAll) {
        this(c, MatchBehavior.Contains, reportAll);
    }

    public AllowedCharacterRule(char[] c, MatchBehavior behavior, boolean reportAll) {
        if (c.length <= 0) {
            throw new IllegalArgumentException("allowed characters length must be greater than zero");
        }
        this.allowedCharacters = c;
        Arrays.sort(this.allowedCharacters);
        this.matchBehavior = behavior;
        this.reportAllFailures = reportAll;
    }

    public char[] getAllowedCharacters() {
        return this.allowedCharacters;
    }

    public MatchBehavior getMatchBehavior() {
        return this.matchBehavior;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult();
        HashSet<Character> matches = new HashSet<Character>();
        String text = passwordData.getPassword();
        for (char c : text.toCharArray()) {
            if (Arrays.binarySearch(this.allowedCharacters, c) >= 0 || matches.contains(Character.valueOf(c)) || !MatchBehavior.Contains.equals((Object)this.matchBehavior) && !this.matchBehavior.match(text, c)) continue;
            String[] codes = new String[]{"ALLOWED_CHAR." + c, "ALLOWED_CHAR." + this.matchBehavior.upperSnakeName(), ERROR_CODE};
            result.addError(codes, this.createRuleResultDetailParameters(c));
            if (!this.reportAllFailures) break;
            matches.add(Character.valueOf(c));
        }
        result.setMetadata(this.createRuleResultMetadata(passwordData));
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("illegalCharacter", Character.valueOf(c));
        m.put("matchBehavior", (Object)this.matchBehavior);
        return m;
    }

    protected RuleResultMetadata createRuleResultMetadata(PasswordData password) {
        return new RuleResultMetadata(RuleResultMetadata.CountCategory.Allowed, PasswordUtils.countMatchingCharacters(String.valueOf(this.allowedCharacters), password.getPassword()));
    }

    public String toString() {
        return String.format("%s@%h::reportAllFailures=%s,matchBehavior=%s,allowedCharacters=%s", new Object[]{this.getClass().getName(), this.hashCode(), this.reportAllFailures, this.matchBehavior, Arrays.toString(this.allowedCharacters)});
    }
}

