/*
 * Decompiled with CFR 0.152.
 */
package com.giffing.wicket.spring.boot.starter.app;

import com.giffing.wicket.spring.boot.context.extensions.WicketApplicationInitConfiguration;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketAutoConfig;
import com.giffing.wicket.spring.boot.context.extensions.boot.actuator.WicketEndpointRepository;
import com.giffing.wicket.spring.boot.context.scan.WicketHomePage;
import com.giffing.wicket.spring.boot.starter.app.WicketBootWebApplication;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidate;
import com.giffing.wicket.spring.boot.starter.app.classscanner.candidates.WicketClassCandidatesHolder;
import com.giffing.wicket.spring.boot.starter.configuration.extensions.core.settings.general.GeneralSettingsProperties;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Page;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;

@Lazy
public class WicketBootStandardWebApplication
extends WebApplication
implements WicketBootWebApplication {
    private static final Logger logger = LoggerFactory.getLogger(WicketBootStandardWebApplication.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private GeneralSettingsProperties generalSettingsProperties;
    @Autowired(required=false)
    private List<WicketApplicationInitConfiguration> configurations = new ArrayList<WicketApplicationInitConfiguration>();
    @Autowired
    private WicketClassCandidatesHolder classCandidates;
    @Autowired
    private WicketEndpointRepository wicketEndpointRepository;

    protected void init() {
        super.init();
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this, this.applicationContext));
        WicketAutoConfig.Builder builder = new WicketAutoConfig.Builder(this.getClass());
        this.wicketEndpointRepository.add(builder.withDetail("signInPages", this.classCandidates.getSignInPageCandidates()).withDetail("homePages", this.classCandidates.getHomePageCandidates()).build());
        for (WicketApplicationInitConfiguration configuration : this.configurations) {
            logger.info("init-config: " + configuration.getClass().getName());
            configuration.init((WebApplication)this);
        }
    }

    public RuntimeConfigurationType getConfigurationType() {
        return this.generalSettingsProperties.getConfigurationType();
    }

    public Class<? extends Page> getHomePage() {
        if (this.classCandidates.getHomePageCandidates().size() <= 0) {
            throw new IllegalStateException("Couln't find home page - please annotate the home page with @" + WicketHomePage.class.getName());
        }
        if (this.classCandidates.getHomePageCandidates().size() > 1) {
            String message = "Multiple home pages found - please annotate exactly one class with @" + WicketHomePage.class.getName();
            message = message + "\n";
            for (WicketClassCandidate<Page> classCandidate : this.classCandidates.getHomePageCandidates()) {
                message = message + "\t" + classCandidate.getCandidate() + "\n";
            }
            throw new IllegalStateException(message);
        }
        Class<Page> next = this.classCandidates.getHomePageCandidates().iterator().next().getCandidate();
        return next;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public GeneralSettingsProperties getGeneralSettingsProperties() {
        return this.generalSettingsProperties;
    }

    public void setGeneralSettingsProperties(GeneralSettingsProperties generalSettingsProperties) {
        this.generalSettingsProperties = generalSettingsProperties;
    }

    public List<WicketApplicationInitConfiguration> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<WicketApplicationInitConfiguration> configurations) {
        this.configurations = configurations;
    }

    public WicketClassCandidatesHolder getClassCandidates() {
        return this.classCandidates;
    }

    public void setClassCandidates(WicketClassCandidatesHolder classCandidates) {
        this.classCandidates = classCandidates;
    }
}

