/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.spring.modules;

import java.util.List;
import javax.servlet.ServletContext;
import org.apache.tapestry5.commons.MappedConfiguration;
import org.apache.tapestry5.commons.OrderedConfiguration;
import org.apache.tapestry5.http.services.ApplicationInitializer;
import org.apache.tapestry5.http.services.ApplicationInitializerFilter;
import org.apache.tapestry5.http.services.Context;
import org.apache.tapestry5.internal.spring.SymbolBeanFactoryPostProcessor;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.ImportModule;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.modules.TapestryModule;
import org.apache.tapestry5.spring.ApplicationContextCustomizer;
import org.slf4j.Logger;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.SpringVersion;
import org.springframework.web.context.ConfigurableWebApplicationContext;

@ImportModule(value={TapestryModule.class})
public class SpringModule {
    private final Logger logger;

    public SpringModule(Logger logger) {
        this.logger = logger;
    }

    @Contribute(value=ApplicationInitializer.class)
    @Primary
    public void reportSpringContextDetailsAtStartup(OrderedConfiguration<ApplicationInitializerFilter> configuration, final ApplicationContext springContext) {
        ApplicationInitializerFilter filter = new ApplicationInitializerFilter(){

            public void initializeApplication(Context context, ApplicationInitializer initializer) {
                SpringModule.this.logger.info(String.format("Spring version %s with %,d defined beans.", SpringVersion.getVersion(), springContext.getBeanDefinitionCount()));
                initializer.initializeApplication(context);
            }
        };
        configuration.add("SpringContextInitialization", (Object)filter, new String[0]);
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void defaultExternalSpringContextOff(MappedConfiguration<String, Object> configuration) {
        configuration.add((Object)"tapestry.use-external-spring-context", (Object)false);
    }

    @Marker(value={Primary.class})
    public static ApplicationContextCustomizer buildApplicationContextCustomizer(List<ApplicationContextCustomizer> configuration, ChainBuilder builder) {
        return (ApplicationContextCustomizer)builder.build(ApplicationContextCustomizer.class, configuration);
    }

    @Contribute(value=ApplicationContextCustomizer.class)
    public static void addSymbolSourceAsPropertyCustomizerForSpringBeans(OrderedConfiguration<ApplicationContextCustomizer> configuration, final SymbolSource symbolSource) {
        ApplicationContextCustomizer beanFactoryPostProcessorCustomizer = new ApplicationContextCustomizer(){

            @Override
            public void customizeApplicationContext(ServletContext servletContext, ConfigurableWebApplicationContext applicationContext) {
                applicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new SymbolBeanFactoryPostProcessor(symbolSource));
            }
        };
        configuration.add("BeanFactoryPostProcessorCustomizer", (Object)beanFactoryPostProcessorCustomizer, new String[0]);
    }
}

