/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.json;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.apache.tapestry5.json.JSON;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONCollection;
import org.apache.tapestry5.json.JSONExceptionBuilder;
import org.apache.tapestry5.json.JSONPrintSession;
import org.apache.tapestry5.json.JSONString;
import org.apache.tapestry5.json.JSONStringer;
import org.apache.tapestry5.json.JSONTokener;
import org.apache.tapestry5.json.JSONType;
import org.apache.tapestry5.json.exceptions.JSONTypeMismatchException;

public final class JSONObject
extends JSONCollection
implements Map<String, Object> {
    private static final long serialVersionUID = 1L;
    private static final Double NEGATIVE_ZERO = -0.0;
    public static final Object NULL = new Serializable(){
        private static final long serialVersionUID = 1L;

        public boolean equals(Object o) {
            return o == this || o == null;
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "null";
        }

        private Object readResolve() throws ObjectStreamException {
            return NULL;
        }
    };
    private final LinkedHashMap<String, Object> nameValuePairs;

    public JSONObject() {
        this.nameValuePairs = new LinkedHashMap();
    }

    JSONObject(JSONTokener readFrom) {
        Object object = readFrom.nextValue(JSONObject.class);
        if (!(object instanceof JSONObject)) {
            throw JSONExceptionBuilder.tokenerTypeMismatch(object, JSONType.OBJECT);
        }
        this.nameValuePairs = ((JSONObject)object).nameValuePairs;
    }

    public JSONObject(String json) {
        this(new JSONTokener(json));
    }

    public JSONObject(JSONObject copyFrom, String ... names) {
        this();
        for (String name : names) {
            Object value = copyFrom.opt(name);
            if (value == null) continue;
            this.nameValuePairs.put(name, value);
        }
    }

    public JSONObject copy() {
        JSONObject dupe = new JSONObject();
        dupe.nameValuePairs.putAll(this.nameValuePairs);
        return dupe;
    }

    public JSONObject(Object ... keysAndValues) {
        this();
        int i = 0;
        while (i < keysAndValues.length) {
            this.put(keysAndValues[i++].toString(), keysAndValues[i++]);
        }
    }

    @Deprecated
    public int length() {
        return this.nameValuePairs.size();
    }

    @Override
    public JSONObject put(String name, Object value) {
        if (value == null) {
            this.nameValuePairs.remove(name);
            return this;
        }
        JSON.testValidity(value);
        if (value instanceof Number) {
            JSON.checkDouble(((Number)value).doubleValue());
        }
        this.nameValuePairs.put(this.checkName(name), value);
        return this;
    }

    public JSONObject accumulate(String name, Object value) {
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current == null) {
            return this.put(name, value);
        }
        if (current instanceof JSONArray) {
            JSONArray array = (JSONArray)current;
            array.checkedPut(value);
        } else {
            JSONArray array = new JSONArray();
            array.checkedPut(current);
            array.checkedPut(value);
            this.nameValuePairs.put(name, array);
        }
        return this;
    }

    public JSONObject append(String name, Object value) {
        JSONArray array;
        JSON.testValidity(value);
        Object current = this.nameValuePairs.get(this.checkName(name));
        if (current instanceof JSONArray) {
            array = (JSONArray)current;
        } else if (current == null) {
            JSONArray newArray = new JSONArray();
            this.nameValuePairs.put(name, newArray);
            array = newArray;
        } else {
            throw new JSONTypeMismatchException("JSONObject[\"" + name + "\"]", JSONType.ARRAY, current.getClass());
        }
        array.checkedPut(value);
        return this;
    }

    String checkName(String name) {
        if (name == null) {
            throw new RuntimeException("Names must be non-null");
        }
        return name;
    }

    public boolean isNull(String name) {
        Object value = this.nameValuePairs.get(name);
        return value == null || value == NULL;
    }

    @Deprecated
    public boolean has(String name) {
        return this.containsKey(name);
    }

    public Object opt(Object name) {
        return this.nameValuePairs.get(name);
    }

    public boolean getBoolean(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.BOOLEAN);
        }
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.BOOLEAN);
        }
        return result;
    }

    public boolean getBooleanOrDefault(String name, boolean defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        Boolean result = JSON.toBoolean(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.BOOLEAN);
        }
        return result;
    }

    public double getDouble(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.NUMBER);
        }
        Double result = JSON.toDouble(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.NUMBER);
        }
        return result;
    }

    public int getInt(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.NUMBER);
        }
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.NUMBER);
        }
        return result;
    }

    public int getIntOrDefault(String name, int defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        Integer result = JSON.toInteger(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.NUMBER);
        }
        return result;
    }

    public long getLong(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.NUMBER);
        }
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.NUMBER);
        }
        return result;
    }

    public long getLongOrDefault(String name, long defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        Long result = JSON.toLong(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.NUMBER);
        }
        return result;
    }

    public String getString(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.STRING);
        }
        String result = JSON.toString(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.STRING);
        }
        return result;
    }

    public String getStringOrDefault(String name, String defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        String result = JSON.toString(object);
        if (result == null) {
            throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.STRING);
        }
        return result;
    }

    public JSONArray getJSONArray(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.ARRAY);
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.ARRAY);
    }

    public JSONArray getJSONArrayOrDefault(String name, JSONArray defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.ARRAY);
    }

    public JSONObject getJSONObject(String name) {
        Object object = this.opt(name);
        if (object == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.OBJECT);
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.OBJECT);
    }

    public JSONObject getJSONObjectOrDefault(String name, JSONObject defaultValue) {
        Object object = this.opt(name);
        if (object == null) {
            return defaultValue;
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONExceptionBuilder.typeMismatch(false, name, object, JSONType.OBJECT);
    }

    public Set<String> keys() {
        return this.nameValuePairs.keySet();
    }

    public JSONArray names() {
        return this.nameValuePairs.isEmpty() ? null : JSONArray.from(this.nameValuePairs.keySet());
    }

    public static String numberToString(Number number) {
        if (number == null) {
            throw new RuntimeException("Number must be non-null");
        }
        double doubleValue = number.doubleValue();
        JSON.checkDouble(doubleValue);
        if (number.equals(NEGATIVE_ZERO)) {
            return "-0";
        }
        long longValue = number.longValue();
        if (doubleValue == (double)longValue) {
            return Long.toString(longValue);
        }
        return number.toString();
    }

    static String doubleToString(double d) {
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return "null";
        }
        return JSONObject.numberToString(d);
    }

    public static String quote(String data) {
        if (data == null) {
            return "\"\"";
        }
        try {
            JSONStringer stringer = new JSONStringer();
            stringer.open(JSONStringer.Scope.NULL, "");
            stringer.string(data);
            stringer.close(JSONStringer.Scope.NULL, JSONStringer.Scope.NULL, "");
            return stringer.toString();
        }
        catch (RuntimeException e) {
            throw new AssertionError();
        }
    }

    @Override
    void print(JSONPrintSession session) {
        session.printSymbol('{');
        session.indent();
        boolean comma = false;
        for (String key : this.keys()) {
            if (comma) {
                session.printSymbol(',');
            }
            session.newline();
            session.printQuoted(key);
            session.printSymbol(':');
            JSONObject.printValue(session, this.nameValuePairs.get(key));
            comma = true;
        }
        session.outdent();
        if (comma) {
            session.newline();
        }
        session.printSymbol('}');
    }

    static void printValue(JSONPrintSession session, Object value) {
        if (value == null || value == NULL) {
            session.print("null");
            return;
        }
        if (value instanceof JSONObject) {
            ((JSONObject)value).print(session);
            return;
        }
        if (value instanceof JSONArray) {
            ((JSONArray)value).print(session);
            return;
        }
        if (value instanceof JSONString) {
            String printValue = ((JSONString)value).toJSONString();
            session.print(printValue);
            return;
        }
        if (value instanceof Number) {
            String printValue = JSONObject.numberToString((Number)value);
            session.print(printValue);
            return;
        }
        if (value instanceof Boolean) {
            session.print(value.toString());
            return;
        }
        session.printQuoted(value.toString());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JSONObject)) {
            return false;
        }
        JSONObject other = (JSONObject)obj;
        return this.nameValuePairs.equals(other.nameValuePairs);
    }

    @Override
    public int hashCode() {
        return this.nameValuePairs.hashCode();
    }

    public Map<String, Object> toMap() {
        return Collections.unmodifiableMap(this.nameValuePairs);
    }

    public JSONObject in(String key) {
        assert (key != null);
        Object nested = this.nameValuePairs.get(key);
        if (nested != null && !(nested instanceof JSONObject)) {
            throw new IllegalStateException(String.format("JSONObject[%s] is not a JSONObject.", JSONObject.quote(key)));
        }
        if (nested == null) {
            nested = new JSONObject();
            this.nameValuePairs.put(key, nested);
        }
        return (JSONObject)nested;
    }

    @Override
    public int size() {
        return this.nameValuePairs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nameValuePairs.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.nameValuePairs.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.nameValuePairs.containsValue(value);
    }

    @Override
    public Object get(Object name) {
        Object result = this.nameValuePairs.get(name);
        if (result == null) {
            throw JSONExceptionBuilder.valueNotFound(false, name, JSONType.ANY);
        }
        return result;
    }

    @Override
    public Object getOrDefault(Object key, Object defaultValue) {
        Object value = this.opt(key);
        return value == null ? defaultValue : value;
    }

    @Override
    public Object remove(Object name) {
        return this.nameValuePairs.remove(name);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> newProperties) {
        assert (newProperties != null);
        for (Map.Entry<? extends String, ? extends Object> e : newProperties.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        this.nameValuePairs.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.nameValuePairs.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.nameValuePairs.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.nameValuePairs.entrySet();
    }

    @Override
    public Object merge(String key, Object value, BiFunction<? super Object, ? super Object, ? extends Object> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        Object oldValue = this.opt(key);
        Object newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        this.put(key, newValue);
        return newValue;
    }
}

