/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.eval.app.db;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.eval.app.db.ColInfo;
import org.apache.tika.eval.app.db.Cols;

public class TableInfo {
    private final String name;
    private final List<ColInfo> colInfos = new ArrayList<ColInfo>();
    private final Set<Cols> colNames = new HashSet<Cols>();
    private String prefix;

    public TableInfo(String name, ColInfo ... cols) {
        Collections.addAll(this.colInfos, cols);
        Collections.unmodifiableList(this.colInfos);
        this.name = name;
        for (ColInfo c : this.colInfos) {
            assert (!this.colNames.contains((Object)c.getName()));
            this.colNames.add(c.getName());
        }
    }

    public TableInfo(String name, List<ColInfo> cols) {
        this.colInfos.addAll(cols);
        Collections.unmodifiableList(this.colInfos);
        this.name = name;
        for (ColInfo c : this.colInfos) {
            assert (!this.colNames.contains((Object)c.getName()));
            this.colNames.add(c.getName());
        }
    }

    public String getName() {
        if (this.prefix == null) {
            return this.name;
        }
        return this.prefix + this.name;
    }

    public void setNamePrefix(String prefix) {
        this.prefix = prefix;
    }

    public List<ColInfo> getColInfos() {
        return this.colInfos;
    }

    public boolean containsColumn(Cols cols) {
        return this.colNames.contains((Object)cols);
    }
}

