/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.sql.util.SQLUtilities;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.factory.IdentifiedObjectFinder;
import org.apache.sis.referencing.factory.sql.EPSGDataAccess;
import org.apache.sis.referencing.factory.sql.TableInfo;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.GenericName;

final class EPSGCodeFinder
extends IdentifiedObjectFinder {
    private final EPSGDataAccess dao;
    private Class<? extends IdentifiedObject> declaredType;

    EPSGCodeFinder(EPSGDataAccess dao) {
        super(dao.owner);
        this.dao = dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<IdentifiedObject> find(IdentifiedObject object) throws FactoryException {
        boolean old = this.dao.quiet;
        this.dao.quiet = true;
        try {
            Set<IdentifiedObject> set = super.find(object);
            return set;
        }
        finally {
            this.dao.quiet = old;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends IdentifiedObject> Condition dependencies(String column, Class<T> type, T dependency, boolean ignoreAxes) throws FactoryException {
        if (dependency != null) {
            Set<IdentifiedObject> find;
            Class<? extends IdentifiedObject> pt = this.declaredType;
            boolean previous = this.isIgnoringAxes();
            try {
                this.setIgnoringAxes(ignoreAxes | previous);
                this.declaredType = type;
                find = this.find(dependency);
            }
            finally {
                this.declaredType = pt;
                this.setIgnoringAxes(previous);
            }
            LinkedHashSet<Number> filters = new LinkedHashSet<Number>(Containers.hashMapCapacity(find.size()));
            for (IdentifiedObject dep : find) {
                Identifier id = IdentifiedObjects.getIdentifier(dep, Citations.EPSG);
                if (id == null) continue;
                try {
                    filters.add(Integer.valueOf(id.getCode()));
                }
                catch (NumberFormatException e) {
                    Logging.recoverableException(EPSGDataAccess.LOGGER, EPSGCodeFinder.class, "getCodeCandidates", e);
                }
            }
            if (!filters.isEmpty()) {
                return new Condition(column, filters);
            }
        }
        return null;
    }

    private boolean isInstance(Class<? extends IdentifiedObject> type, IdentifiedObject object) {
        return (this.declaredType == null || type.isAssignableFrom(this.declaredType)) && type.isInstance(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set<String> getCodeCandidates(IdentifiedObject object) throws FactoryException {
        Object filter;
        String aliasSQL;
        LinkedHashSet<String> namePatterns;
        Object[] filters;
        TableInfo table;
        block52: {
            List<CoordinateReferenceSystem> components;
            block58: {
                block55: {
                    Condition filter2;
                    block56: {
                        int n;
                        block57: {
                            if (!this.isInstance(CoordinateReferenceSystem.class, object)) break block55;
                            table = TableInfo.CRS;
                            if (!this.isInstance(CompoundCRS.class, object) || (components = ((CompoundCRS)object).getComponents()) == null) break block56;
                            n = components.size();
                            if (n != 2) break block57;
                            filters = new Condition[2];
                            break block58;
                        }
                        if (n == 1) {
                            return this.getCodeCandidates(components.get(0));
                        }
                    }
                    if (object instanceof GeneralDerivedCRS) {
                        filter2 = this.dependencies("SOURCE_GEOGCRS_CODE", CoordinateReferenceSystem.class, ((GeneralDerivedCRS)object).getBaseCRS(), true);
                    } else if (object instanceof GeodeticCRS) {
                        filter2 = this.dependencies("DATUM_CODE", GeodeticDatum.class, ((GeodeticCRS)object).getDatum(), true);
                    } else if (object instanceof VerticalCRS) {
                        filter2 = this.dependencies("DATUM_CODE", VerticalDatum.class, ((VerticalCRS)object).getDatum(), true);
                    } else if (object instanceof TemporalCRS) {
                        filter2 = this.dependencies("DATUM_CODE", TemporalDatum.class, ((TemporalCRS)object).getDatum(), true);
                    } else {
                        if (!(object instanceof SingleCRS)) return Set.of();
                        filter2 = this.dependencies("DATUM_CODE", Datum.class, ((SingleCRS)object).getDatum(), true);
                    }
                    if (filter2 == null) {
                        return Set.of();
                    }
                    filters = new Condition[]{filter2};
                    break block52;
                }
                if (this.isInstance(Datum.class, object)) {
                    table = TableInfo.DATUM;
                    if (this.isInstance(GeodeticDatum.class, object)) {
                        filters = new Condition[]{this.dependencies("ELLIPSOID_CODE", Ellipsoid.class, ((GeodeticDatum)object).getEllipsoid(), true), Condition.NAME};
                        if (filters[0] == null) {
                            return Set.of();
                        }
                        break block52;
                    } else {
                        VerticalDatumType type;
                        if (this.isInstance(VerticalDatum.class, object) && (type = ((VerticalDatum)object).getVerticalDatumType()) != null && !type.equals(EPSGDataAccess.VERTICAL_DATUM_TYPE)) {
                            return Set.of();
                        }
                        filters = new Condition[]{Condition.NAME};
                    }
                    break block52;
                } else {
                    if (!this.isInstance(Ellipsoid.class, object)) return super.getCodeCandidates(object);
                    table = TableInfo.ELLIPSOID;
                    filters = new Condition[]{new FloatCondition("SEMI_MAJOR_AXIS", ((Ellipsoid)object).getSemiMajorAxis())};
                }
                break block52;
            }
            for (int i = 0; i <= 1; ++i) {
                filters[i] = this.dependencies(i == 0 ? "CMPD_HORIZCRS_CODE" : "CMPD_VERTCRS_CODE", CoordinateReferenceSystem.class, components.get(i), false);
                if (filters[i] != null) continue;
                return Set.of();
            }
        }
        StringBuilder buffer = new StringBuilder(350);
        if (ArraysExt.containsIdentity(filters, Condition.NAME)) {
            namePatterns = new LinkedHashSet<String>();
            namePatterns.add(EPSGCodeFinder.toDatumPattern(object.getName().getCode(), buffer));
            for (GenericName genericName : object.getAlias()) {
                namePatterns.add(EPSGCodeFinder.toDatumPattern(genericName.tip().toString(), buffer));
            }
            buffer.setLength(0);
            buffer.append("SELECT OBJECT_CODE FROM [Alias] WHERE OBJECT_TABLE_NAME='").append(table.unquoted()).append("' AND ");
            EPSGCodeFinder.appendFilterByName(namePatterns, "ALIAS", buffer);
            aliasSQL = this.dao.translator.apply(buffer.toString());
            buffer.setLength(0);
        } else {
            namePatterns = null;
            aliasSQL = null;
        }
        buffer.append("SELECT ").append(table.codeColumn).append(" FROM ").append(table.table);
        table.where(object.getClass(), buffer);
        boolean isNext = false;
        Object[] objectArray = filters;
        int n = objectArray.length;
        for (int i = 0; i < n; isNext |= ((Condition)filter).appendToWhere(buffer, isNext), ++i) {
            filter = objectArray[i];
        }
        try (Statement statement = this.dao.connection.createStatement();){
            if (namePatterns != null) {
                if (isNext) {
                    buffer.append(" AND ");
                }
                isNext = false;
                EPSGCodeFinder.appendFilterByName(namePatterns, table.nameColumn, buffer);
                try (ResultSet result = statement.executeQuery(aliasSQL);){
                    while (result.next()) {
                        int code = result.getInt(1);
                        if (result.wasNull()) continue;
                        if (!isNext) {
                            isNext = true;
                            buffer.append(" OR ").append(table.codeColumn).append(" IN (");
                        } else {
                            buffer.append(',');
                        }
                        buffer.append(code);
                    }
                }
                if (isNext) {
                    buffer.append(')');
                }
            }
            buffer.append(this.getSearchDomain() == IdentifiedObjectFinder.Domain.ALL_DATASET ? " ORDER BY ABS(DEPRECATED), " : " AND DEPRECATED=0 ORDER BY ");
            for (Object filter3 : filters) {
                ((Condition)filter3).appendToOrderBy(buffer);
            }
            buffer.append(table.codeColumn);
            LinkedHashSet result = new LinkedHashSet();
            try (ResultSet r = statement.executeQuery(this.dao.translator.apply(buffer.toString()));){
                while (r.next()) {
                    result.add(r.getString(1));
                }
            }
            result.remove(null);
            if (result.size() > 1) {
                Object[] id = result.toArray();
                if (this.dao.sort(table.unquoted(), id)) {
                    result.clear();
                    for (Object c : id) {
                        result.add((String)c);
                    }
                }
            }
            Object object2 = result;
            return object2;
        }
        catch (SQLException sQLException) {
            throw this.dao.databaseFailure(Identifier.class, (Comparable<?>)((Object)String.valueOf(CollectionsExt.first(((Condition)filters[0]).values))), sQLException);
        }
    }

    private static String toDatumPattern(String name, StringBuilder buffer) {
        int end;
        int start = 0;
        if (name.startsWith("D_")) {
            start = "D_".length();
        }
        if ((end = name.indexOf(40)) < 0) {
            end = name.length();
        }
        end = CharSequences.skipTrailingWhitespaces(name, start, end);
        buffer.setLength(0);
        SQLUtilities.toLikePattern(name, start, end, true, true, buffer);
        return buffer.toString();
    }

    private static void appendFilterByName(Set<String> namePatterns, String column, StringBuilder buffer) {
        String separator = "(";
        for (String pattern : namePatterns) {
            buffer.append(separator).append("LOWER(").append(column).append(") LIKE '").append(pattern).append('\'');
            separator = " OR ";
        }
        buffer.append(')');
    }

    private static class Condition {
        static final Condition NAME = new Condition("NAME", Set.of());
        final String column;
        final Set<Number> values;

        Condition(String column, Set<Number> values) {
            this.column = column;
            this.values = values;
        }

        boolean appendToWhere(StringBuilder buffer, boolean isNext) {
            if (this.values.isEmpty()) {
                return false;
            }
            if (isNext) {
                buffer.append(" AND ");
            }
            buffer.append(this.column);
            if (this.values.size() == 1) {
                buffer.append('=').append(CollectionsExt.first(this.values));
            } else {
                buffer.append(" IN (");
                for (Number code : this.values) {
                    buffer.append(code).append(',');
                }
                buffer.setCharAt(buffer.length() - 1, ')');
            }
            return true;
        }

        void appendToOrderBy(StringBuilder buffer) {
        }

        public final String toString() {
            StringBuilder buffer = new StringBuilder(50);
            this.appendToWhere(buffer, false);
            return buffer.toString();
        }
    }

    private static final class FloatCondition
    extends Condition {
        FloatCondition(String column, double value) {
            super(column, Set.of(Double.valueOf(value)));
        }

        @Override
        boolean appendToWhere(StringBuilder buffer, boolean isNext) {
            if (isNext) {
                buffer.append(" AND ");
            }
            double value = ((Number)this.values.iterator().next()).doubleValue();
            double tolerance = Math.abs(1.5696105811844188E-9 * value);
            buffer.append(this.column).append(">=").append(value - tolerance).append(" AND ").append(this.column).append("<=").append(value + tolerance);
            return true;
        }

        @Override
        void appendToOrderBy(StringBuilder buffer) {
            double value = ((Number)this.values.iterator().next()).doubleValue();
            buffer.append("ABS(").append(this.column).append('-').append(value).append("), ");
        }
    }
}

