/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.function.Function;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;

public enum T implements Function<Element, Object>
{
    label{

        @Override
        public String getAccessor() {
            return LABEL;
        }

        @Override
        public String apply(Element element) {
            return element.label();
        }
    }
    ,
    id{

        @Override
        public String getAccessor() {
            return ID;
        }

        @Override
        public Object apply(Element element) {
            return element.id();
        }
    }
    ,
    key{

        @Override
        public String getAccessor() {
            return KEY;
        }

        @Override
        public String apply(Element element) {
            return ((VertexProperty)element).key();
        }
    }
    ,
    value{

        @Override
        public String getAccessor() {
            return VALUE;
        }

        @Override
        public Object apply(Element element) {
            return ((VertexProperty)element).value();
        }
    };

    private static final String LABEL;
    private static final String ID;
    private static final String KEY;
    private static final String VALUE;

    public abstract String getAccessor();

    @Override
    public abstract Object apply(Element var1);

    public static T fromString(String accessor) {
        if (accessor.equals(LABEL)) {
            return label;
        }
        if (accessor.equals(ID)) {
            return id;
        }
        if (accessor.equals(KEY)) {
            return key;
        }
        if (accessor.equals(VALUE)) {
            return value;
        }
        throw new IllegalArgumentException("The following token string is unknown: " + accessor);
    }

    static {
        LABEL = Graph.Hidden.hide("label");
        ID = Graph.Hidden.hide("id");
        KEY = Graph.Hidden.hide("key");
        VALUE = Graph.Hidden.hide("value");
    }
}

