/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.util.message.RequestMessage;
import org.apache.tinkerpop.gremlin.util.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.util.ser.AbstractMessageSerializer;

public class TextPlainMessageSerializer
extends AbstractMessageSerializer<Function<Object, String>> {
    public Function<Object, String> getMapper() {
        return Objects::toString;
    }

    public ByteBuf serializeResponseAsBinary(ResponseMessage responseMessage, ByteBufAllocator allocator) {
        return responseMessage.getStatus().getCode() == HttpResponseStatus.OK ? this.convertStringData(responseMessage.getResult().getData(), false, allocator) : this.convertErrorString(responseMessage.getStatus().getMessage(), allocator);
    }

    public ByteBuf writeHeader(ResponseMessage responseMessage, ByteBufAllocator allocator) {
        return this.convertStringData(responseMessage.getResult().getData(), false, allocator);
    }

    public ByteBuf writeChunk(Object aggregate, ByteBufAllocator allocator) {
        return this.convertStringData((List)aggregate, true, allocator);
    }

    public ByteBuf writeFooter(ResponseMessage responseMessage, ByteBufAllocator allocator) {
        return this.convertStringData(responseMessage.getResult().getData(), true, allocator);
    }

    public ByteBuf writeErrorFooter(ResponseMessage responseMessage, ByteBufAllocator allocator) {
        return this.convertErrorString(System.lineSeparator() + responseMessage.getStatus().getMessage(), allocator);
    }

    public ResponseMessage readChunk(ByteBuf byteBuf, boolean isFirstChunk) {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public ByteBuf serializeRequestAsBinary(RequestMessage requestMessage, ByteBufAllocator allocator) {
        throw new UnsupportedOperationException("text/plain does not produce binary");
    }

    public RequestMessage deserializeBinaryRequest(ByteBuf msg) {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public ResponseMessage deserializeBinaryResponse(ByteBuf msg) {
        throw new UnsupportedOperationException("text/plain does not have deserialization functions");
    }

    public String[] mimeTypesSupported() {
        return new String[]{"text/plain"};
    }

    private ByteBuf convertStringData(List<Object> data, boolean addStartingSeparator, ByteBufAllocator allocator) {
        StringBuilder sb = new StringBuilder();
        if (addStartingSeparator) {
            sb.append(System.lineSeparator());
        }
        for (int ix = 0; ix < data.size(); ++ix) {
            sb.append("==>");
            sb.append(data.get(ix));
            if (ix >= data.size() - 1) continue;
            sb.append(System.lineSeparator());
        }
        ByteBuf encodedMessage = allocator.buffer(sb.length());
        encodedMessage.writeCharSequence((CharSequence)sb.toString(), CharsetUtil.UTF_8);
        return encodedMessage;
    }

    private ByteBuf convertErrorString(String error, ByteBufAllocator allocator) {
        ByteBuf encodedMessage = allocator.buffer(error.length());
        encodedMessage.writeCharSequence((CharSequence)error, CharsetUtil.UTF_8);
        return encodedMessage;
    }
}

