/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionJavaPrinter;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class ConstantExpression
extends Expression {
    protected Object value;
    protected Expression localBase;
    protected Boolean canBind = null;

    public ConstantExpression() {
    }

    public ConstantExpression(Object newValue, Expression baseExpression) {
        this.value = newValue;
        this.localBase = baseExpression;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ConstantExpression expression = (ConstantExpression)object;
        return this.value == expression.getValue() || this.value != null && this.value.equals(expression.getValue());
    }

    @Override
    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.value != null) {
            hashCode += this.value.hashCode();
        }
        return hashCode;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Constant";
    }

    @Override
    public ExpressionBuilder getBuilder() {
        if (this.localBase != null) {
            return this.localBase.getBuilder();
        }
        return null;
    }

    public Expression getLocalBase() {
        return this.localBase;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Boolean canBind() {
        return this.canBind;
    }

    public void setCanBind(Boolean canBind) {
        this.canBind = canBind;
    }

    @Override
    public boolean isConstantExpression() {
        return true;
    }

    @Override
    public boolean isValueExpression() {
        return true;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        super.normalize(normalizer);
        if (this.value == null) {
            return this;
        }
        if (this.value instanceof Collection) {
            this.normalizeValueList(normalizer, (Collection)this.value);
        }
        return this;
    }

    private void normalizeValueList(ExpressionNormalizer normalizer, Collection valueCollection) {
        for (Object obj : valueCollection) {
            if (obj instanceof Collection) {
                this.normalizeValueList(normalizer, (Collection)obj);
                continue;
            }
            if (!(obj instanceof Expression)) continue;
            ((Expression)obj).normalize(normalizer);
        }
    }

    @Override
    protected void postCopyIn(Map alreadyDone) {
        super.postCopyIn(alreadyDone);
        if (this.localBase != null) {
            this.localBase = this.localBase.copiedVersionFrom(alreadyDone);
        }
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        Object value = this.value;
        if (this.localBase != null) {
            value = this.localBase.getFieldValue(value, this.getSession());
        }
        if (value == null) {
            printer.printNull(this);
        } else {
            printer.printPrimitive(value, this.canBind);
        }
    }

    @Override
    public void printJava(ExpressionJavaPrinter printer) {
        printer.printJava(this.value);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        ConstantExpression result = (ConstantExpression)this.clone();
        Expression localBase = null;
        if (this.localBase != null) {
            localBase = this.localBase.rebuildOn(newBase);
        }
        ((Expression)result).setLocalBase(localBase);
        return result;
    }

    @Override
    public void resetPlaceHolderBuilder(ExpressionBuilder queryBuilder) {
    }

    @Override
    public void setLocalBase(Expression e) {
        this.localBase = e;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        return this;
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        if (this.localBase != null) {
            return this.localBase.getFieldValue(this.value, session);
        }
        return this.value;
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(String.valueOf(this.value));
    }

    @Override
    public void writeFields(ExpressionSQLPrinter printer, List<DatabaseField> newFields, SQLSelectStatement statement) {
        if (printer.getPlatform().isDynamicSQLRequiredForFunctions()) {
            printer.getCall().setUsesBinding(false);
        }
        if (!printer.getPlatform().allowBindingForSelectClause()) {
            this.setCanBind(false);
        }
        if (printer.isFirstElementPrinted()) {
            printer.printString(", ");
        } else {
            printer.setIsFirstElementPrinted(true);
        }
        newFields.add(new DatabaseField("*"));
        this.printSQL(printer);
    }
}

