/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.hash;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public final class XxHash64 {
    private static final long PRIME64_1 = -7046029288634856825L;
    private static final long PRIME64_2 = -4417276706812531889L;
    private static final long PRIME64_3 = 1609587929392839161L;
    private static final long PRIME64_4 = -8796714831421723037L;
    private static final long PRIME64_5 = 2870177450012600261L;

    private XxHash64() {
    }

    public static long apply(String input) {
        return XxHash64.apply(ByteBuffer.wrap(input.getBytes(StandardCharsets.UTF_8)));
    }

    public static long apply(ByteBuffer input) {
        long hash;
        int length = input.remaining();
        long remaining = length;
        int off = 0;
        if (remaining >= 32L) {
            long v1 = 6983438078262162902L;
            long v2 = -4417276706812531889L;
            long v3 = 0L;
            long v4 = 7046029288634856825L;
            do {
                v1 += input.getLong(off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += input.getLong(off + 8) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += input.getLong(off + 16) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v3 *= -7046029288634856825L;
                v4 += input.getLong(off + 24) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                off += 32;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = 2870177450012600261L;
        }
        hash += (long)length;
        while (remaining >= 8L) {
            long k1 = input.getLong(off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= ((long)input.getInt(off) & 0xFFFFFFFFL) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= (long)(input.get(off) & 0xFF) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++off;
        }
        return XxHash64.finalize(hash);
    }

    private static long finalize(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }
}

