/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.opentelemetry;

import io.smallrye.opentelemetry.implementation.rest.OpenTelemetryClientFilter;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;

public class LazyOpenTelemetryClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(LazyOpenTelemetryClientFilter.class.getName());
    private OpenTelemetryClientFilter delegate;

    public void filter(ClientRequestContext requestContext) throws IOException {
        this.delegate().filter(requestContext);
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        this.delegate().filter(requestContext, responseContext);
    }

    protected OpenTelemetryClientFilter delegate() {
        if (this.delegate == null) {
            try {
                this.delegate = (OpenTelemetryClientFilter)CDI.current().select(OpenTelemetryClientFilter.class, new Annotation[0]).get();
            }
            catch (IllegalStateException ise) {
                LOGGER.warning("No CDI context available, falling back to NoOp");
                this.delegate = new NoOp();
            }
        }
        return this.delegate;
    }

    private static class NoOp
    extends OpenTelemetryClientFilter {
        private NoOp() {
        }

        public void filter(ClientRequestContext requestContext) {
        }

        public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        }
    }
}

