/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.xbean.osgi.bundle.util.HeaderParser;

public class HeaderBuilder {
    private static final Pattern EXTENDED_PATTERN = Pattern.compile("[\\w_\\-\\.]+");

    public static String build(List<HeaderParser.HeaderElement> headerElements) {
        if (headerElements == null || headerElements.size() == 0) {
            return "";
        }
        StringBuilder header = new StringBuilder();
        for (HeaderParser.HeaderElement headerElement : headerElements) {
            String name = headerElement.getName();
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("Invalid header name for the header elment " + headerElement);
            }
            if (header.length() > 0) {
                header.append(",");
            }
            header.append(name);
            for (Map.Entry<String, String> attribute : headerElement.getAttributes().entrySet()) {
                header.append(";").append(attribute.getKey()).append("=");
                if (EXTENDED_PATTERN.matcher(attribute.getValue()).matches()) {
                    header.append(attribute.getValue());
                    continue;
                }
                header.append("\"").append(attribute.getValue()).append("\"");
            }
            for (Map.Entry<String, String> directive : headerElement.getDirectives().entrySet()) {
                header.append(";").append(directive.getKey()).append(":=");
                if (EXTENDED_PATTERN.matcher(directive.getValue()).matches()) {
                    header.append(directive.getValue());
                    continue;
                }
                header.append("\"").append(directive.getValue()).append("\"");
            }
        }
        return header.toString();
    }
}

