/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import java.net.URI;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.xml.sax.InputSource;

public class DefaultSchemaResolver
implements SchemaResolver {
    private String baseSchemaLocation;

    @Override
    public Source resolveSchema(Source sourceXSD, String namespace, String schemaLocation) {
        try {
            URL schemaUrl = null;
            String baseLoc = this.getBaseSchemaLocation();
            if (baseLoc == null) {
                URI schemaUri = new URI(schemaLocation);
                if (!schemaUri.isAbsolute() && sourceXSD.getSystemId() != null) {
                    baseLoc = sourceXSD.getSystemId();
                    schemaUrl = new URI(baseLoc).resolve(schemaUri).toURL();
                } else {
                    schemaUrl = new URI(schemaLocation).toURL();
                }
            } else {
                URI baseUri;
                URI schemaUri = new URI(schemaLocation);
                schemaUrl = schemaUri.isAbsolute() ? schemaUri.toURL() : ((baseUri = new URI(baseLoc)).isOpaque() && baseUri.getScheme().equals("jar") ? new URI(baseLoc.substring(0, baseLoc.lastIndexOf(47) + 1) + schemaLocation).toURL() : new URI(baseLoc).resolve(schemaUri).toURL());
            }
            return new StreamSource(schemaUrl.toExternalForm());
        }
        catch (Exception e) {
            AbstractSessionLog.getLog().log(6, "sdo_error_processing_referenced_schema", new Object[]{e.getClass().getName(), namespace, schemaLocation});
            AbstractSessionLog.getLog().logThrowable(1, e);
            return null;
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        return null;
    }

    public void setBaseSchemaLocation(String baseSchemaLocation) {
        this.baseSchemaLocation = baseSchemaLocation;
    }

    public String getBaseSchemaLocation() {
        return this.baseSchemaLocation;
    }
}

