/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import java.io.Serializable;
import org.apache.openjpa.conf.OpenJPAConfiguration;

public class Slice
implements Comparable<Slice>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final transient OpenJPAConfiguration conf;
    private transient Status status;

    public Slice(String name, OpenJPAConfiguration conf) {
        this.name = name;
        this.conf = conf;
        this.status = Status.NOT_INITIALIZED;
    }

    public String getName() {
        return this.name;
    }

    public OpenJPAConfiguration getConfiguration() {
        return this.conf;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean isActive() {
        return this.status == Status.ACTIVE;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(Slice other) {
        return this.name.compareTo(other.name);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Slice) {
            return this.name.equals(((Slice)other).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum Status {
        NOT_INITIALIZED,
        ACTIVE,
        INACTIVE,
        EXCLUDED;

    }
}

