
# Compatibility Report

![semver MINOR](https://img.shields.io/badge/semver-MINOR-orange?logo=semver "semver MINOR")

## Summary

> [!WARNING]
>
> Compatible changes found while checking backward compatibility of version `3.6.0` with the previous version `3.5.0`.

<details markdown="1">
<summary>Expand to see options used.</summary>

- **Report only summary**: No
- **Report only changes**: Yes
- **Report only binary-incompatible changes**: No
- **Access modifier filter**: `PROTECTED`
- **Old archives**:
  - ![uimaj-core 3.5.0](https://img.shields.io/badge/uimaj_core-3.5.0-blue "uimaj-core 3.5.0")
- **New archives**:
  - ![uimaj-core 3.6.0](https://img.shields.io/badge/uimaj_core-3.6.0-blue "uimaj-core 3.6.0")
- **Evaluate annotations**: Yes
- **Include synthetic classes and class members**: No
- **Include specific elements**: No
- **Exclude specific elements**: No
- **Ignore all missing classes**: No
- **Ignore specific missing classes**: Yes
  - `com\.strobel\..*`
  - `org\.apache\.logging\.log4j\..*`
- **Treat changes as errors**:
  - Any changes: No
  - Binary incompatible changes: No
  - Source incompatible changes: No
  - Incompatible changes caused by excluded classes: Yes
  - Semantically incompatible changes: No
  - Semantically incompatible changes, including development versions: No
- **Classpath mode**: `ONE_COMMON_CLASSPATH`
- **Old classpath**:
```

```
- **New classpath**:
```

```

</details>


## Results

| Status    | Type                                                             | Serialization       | Compatibility Changes |
|-----------|------------------------------------------------------------------|---------------------|-----------------------|
| Unchanged | [org.apache.uima.Constants]                                      | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.List_of_ints]                                   | ![Not serializable] | ![Annotation deprecated added] |
| Modified  | [org.apache.uima.UIMAFramework]                                  | ![Not serializable] | ![Annotation deprecated added] ![Annotation modified] ![Method added to public class] |
| Unchanged | [org.apache.uima.UimaContext]                                    | ![Not serializable] | ![Annotation modified] |
| Modified  | [org.apache.uima.UimaContextAdmin]                               | ![Not serializable] | ![Annotation deprecated added] ![Method new default] |
| Added     | [org.apache.uima.UimaContextAdminBuilder]                        | ![Not serializable] | ![Method added to public class] |
| Unchanged | [org.apache.uima.analysis_engine.AnalysisEngine]                 | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.AnalysisProcessData]            | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.TextAnalysisEngine]             | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.AnnotatorContext]     | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.AnnotatorContextException] | ![Compatible]  | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.Annotator_ImplBase]   | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.BaseAnnotator]        | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.GenericAnnotator]     | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.GenericAnnotator_ImplBase] | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.JTextAnnotator]       | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase] | ![Not serializable] | ![Annotation modified] |
| Modified  | [org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow] | ![Compatible]      | ![Method now varargs] |
| Modified  | [org.apache.uima.analysis_engine.metadata.FixedFlow]             | ![Compatible]       | ![Method now varargs] |
| Unchanged | [org.apache.uima.cas.CAS]                                        | ![Not serializable] | ![Annotation deprecated added] ![Annotation modified] |
| Unchanged | [org.apache.uima.cas.FeaturePath]                                | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.cas.FeatureValuePath]                           | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.cas.SofaID]                                     | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.cas.admin.CASFactory]                           | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.cas.admin.CASMgr]                               | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.CasInitializer]                      | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.CasInitializerDescription]           | ![Compatible]       | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.CasInitializer_ImplBase]             | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.CollectionReader]                    | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.CollectionReader_ImplBase]           | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.base_cpm.CasDataCollectionReader]    | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.base_cpm.CasDataInitializer]         | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.base_cpm.CasDataInitializer_ImplBase] | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.metadata.CpeCasProcessor]            | ![Compatible]       | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.metadata.CpeCollectionReader]        | ![Compatible]       | ![Annotation deprecated added] ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer] | ![Compatible] | ![Annotation modified] |
| Unchanged | [org.apache.uima.collection.metadata.CpeDescription]             | ![Compatible]       | ![Annotation modified] |
| Modified  | [org.apache.uima.collection.metadata.CpeSofaMappings]            | ![Compatible]       | ![Method now varargs] |
| Unchanged | [org.apache.uima.flow.CasFlow_ImplBase]                          | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.jcas.JCas]                                      | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.jcas.cas.ArrayFSImpl]                           | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.jcas.tcas.Annotation]                           | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.pear.tools.InstallationController]              | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.pear.tools.InstallationDescriptor]              | ![Compatible]       | ![Annotation modified] |
| Modified  | [org.apache.uima.resource.CustomResourceSpecifier]               | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.ParameterizedDataResource]             | ![Not serializable] | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.RelativePathResolver]                  | ![Not serializable] | ![Annotation deprecated added] ![Annotation modified] ![Method added to interface] |
| Modified  | [org.apache.uima.resource.ResourceCreationSpecifier]             | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.ResourceManager]                       | ![Not serializable] | ![Annotation deprecated added] ![Annotation modified] ![Method now varargs] ![Method added to interface] |
| Modified  | [org.apache.uima.resource.URISpecifier]                          | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.Capability]                   | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ConfigurationGroup]           | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ConfigurationParameter]       | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ConfigurationParameterDeclarations] | ![Compatible] | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ConfigurationParameterSettings] | ![Compatible]     | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.FsIndexCollection]            | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.FsIndexDescription]           | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.LanguagePrecondition]         | ![Compatible]       | ![Method now varargs] |
| Unchanged | [org.apache.uima.resource.metadata.MetaDataObject]               | ![Compatible]       | ![Annotation modified] |
| Modified  | [org.apache.uima.resource.metadata.MimeTypePrecondition]         | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ProcessingResourceMetaData]   | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.ResourceManagerConfiguration] | ![Compatible]       | ![Annotation modified] ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.TypeDescription]              | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.TypePriorities]               | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.TypePriorityList]             | ![Compatible]       | ![Method now varargs] |
| Modified  | [org.apache.uima.resource.metadata.TypeSystemDescription]        | ![Compatible]       | ![Method now varargs] |
| Unchanged | [org.apache.uima.spi.FsIndexCollectionProvider]                  | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.spi.JCasClassProvider]                          | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.spi.TypePrioritiesProvider]                     | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.spi.TypeSystemDescriptionProvider]              | ![Not serializable] | ![Annotation deprecated added] |
| Added     | [org.apache.uima.spi.TypeSystemProvider]                         | ![Not serializable] | ![Interface added]    |
| Added     | [org.apache.uima.spi.TypeSystemProvider_ImplBase]                | ![Not serializable] | ![Interface added] ![Method added to public class] |
| Unchanged | [org.apache.uima.uimacpp.CppUimajEngine]                         | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.uimacpp.UimacppAnalysisComponent]               | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.uimacpp.UimacppEngine]                          | ![Not serializable] | ![Annotation deprecated added] |
| Unchanged | [org.apache.uima.util.Logger]                                    | ![Not serializable] | ![Annotation modified] |
| Modified  | [org.apache.uima.util.TypeSystemUtil]                            | ![Not serializable] | ![Method added to public class] |
| Unchanged | [org.apache.uima.util.XMLInputSource]                            | ![Not serializable] | ![Annotation modified] |
| Unchanged | [org.apache.uima.util.XMLParser]                                 | ![Not serializable] | ![Annotation deprecated added] ![Annotation modified] |

<details markdown="1">
<summary>Expand for details.</summary>

___

<a id="user-content-org.apache.uima.constants"></a>
### `org.apache.uima.Constants`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name        | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|-------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `Constants` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Fields

| Status    | Modifiers                 | Type       | Name                             | Annotations                               | Compatibility Changes |
|-----------|---------------------------|------------|----------------------------------|-------------------------------------------|-----------------------|
| Unchanged | `public` `static` `final` | [`String`] | `PROTOCOL_SOAP`                  | [`Deprecated`]: **`since`**=**`"3.3.0"`** | ![Annotation modified] |
| Unchanged | `public` `static` `final` | [`String`] | `PROTOCOL_SOAP_WITH_ATTACHMENTS` | [`Deprecated`]: **`since`**=**`"3.3.0"`** | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.list_of_ints"></a>
### `org.apache.uima.List_of_ints`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name           | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `List_of_ints` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation                                    | Compatibility Changes |
|--------|-----------------------------------------------|-----------------------|
| Added  | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.uimaframework"></a>
### `org.apache.uima.UIMAFramework`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type  | Name            | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|---------------------|-------|-----------------|------------|--------|---------------------|-----------------------|
| Modified | `public` `abstract` | Class | `UIMAFramework` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers                 | Generics | Type                            | Method                                                       | Annotations                                   | Throws                              | Compatibility Changes |
|-----------|---------------------------|----------|---------------------------------|--------------------------------------------------------------|-----------------------------------------------|-------------------------------------|-----------------------|
| Unchanged | `static` `public`         |          | [`UimaContextAdmin`]            | `newUimaContext`([`Logger`], [`ResourceManager`], [`ConfigurationManager`]) | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |                      | ![Annotation deprecated added] |
| Added     | **`static`** **`public`** |          | **[`UimaContextAdmin`]**        | **`newUimaContext`**()                                       |                                               |                                     | ![Method added to public class] |
| Unchanged | `static` `public`         |          | [`CasInitializer`]              | `produceCasInitializer`([`ResourceSpecifier`])               | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`ResourceInitializationException`] | ![Annotation modified] |
| Unchanged | `static` `public`         |          | [`TextAnalysisEngine`]          | `produceTAE`([`ResourceSpecifier`])                          | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`ResourceInitializationException`] | ![Annotation modified] |
| Unchanged | `static` `public`         |          | [`TextAnalysisEngine`]          | `produceTAE`([`ResourceSpecifier`], [`Map<String, Object>`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`ResourceInitializationException`] | ![Annotation modified] |
| Unchanged | `static` `public`         |          | [`TextAnalysisEngine`]          | `produceTAE`([`ResourceSpecifier`], [`ResourceManager`], [`Map<String, Object>`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** | [`ResourceInitializationException`] | ![Annotation modified] |
| Added     | **`static`** **`public`** |          | **[`UimaContextAdminBuilder`]** | **`uimaContextBuilder`**()                                   |                                               |                                     | ![Method added to public class] |

___

<a id="user-content-org.apache.uima.uimacontext"></a>
### `org.apache.uima.UimaContext`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name          | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `UimaContext` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type       | Method          | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|------------|-----------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`String`] | `getDataPath`() | [`Deprecated`]: **`since`**=**`"3.4.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.uimacontextadmin"></a>
### `org.apache.uima.UimaContextAdmin`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|---------------------|-----------|--------------------|------------|--------|---------------------|-----------------------|
| Modified | `public` `abstract` | Interface | `UimaContextAdmin` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type       | Method                           | Annotations                                   | Throws | Compatibility Changes |
|-----------|---------------------|----------|------------|----------------------------------|-----------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | `void`     | `initializeRoot`([`Logger`], [`ResourceManager`], [`ConfigurationManager`]) | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |  | ![Annotation deprecated added] |
| Added     | **`public`**        |          | **`void`** | **`initializeRoot`**([`Logger`]) |                                               |        | ![Method new default] |

___

<a id="user-content-org.apache.uima.uimacontextadminbuilder"></a>
### `org.apache.uima.UimaContextAdminBuilder`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status | Modifiers    | Type      | Name                          | Extends        | JDK        | Serialization       | Compatibility Changes |
|--------|--------------|-----------|-------------------------------|----------------|------------|---------------------|-----------------------|
| Added  | **`public`** | **Class** | **`UimaContextAdminBuilder`** | **[`Object`]** | **JDK 17** | ![Not serializable] | ![No changes]         |


#### Constructors

| Status | Modifiers    | Generics | Constructor                     | Annotations | Throws | Compatibility Changes |
|--------|--------------|----------|---------------------------------|-------------|--------|-----------------------|
| Added  | **`public`** |          | **`UimaContextAdminBuilder`**() |             |        | ![No changes]         |


#### Methods

| Status | Modifiers    | Generics | Type                            | Method                                                   | Annotations | Throws | Compatibility Changes |
|--------|--------------|----------|---------------------------------|----------------------------------------------------------|-------------|--------|-----------------------|
| Added  | **`public`** |          | **[`UimaContextAdmin`]**        | **`build`**()                                            |             |        | ![Method added to public class] |
| Added  | **`public`** |          | **[`UimaContextAdminBuilder`]** | **`withConfigurationManager`**([`ConfigurationManager`]) |             |        | ![Method added to public class] |
| Added  | **`public`** |          | **[`UimaContextAdminBuilder`]** | **`withLogger`**([`Logger`])                             |             |        | ![Method added to public class] |
| Added  | **`public`** |          | **[`UimaContextAdminBuilder`]** | **`withResourceManager`**([`ResourceManager`])           |             |        | ![Method added to public class] |

___

<a id="user-content-org.apache.uima.analysis_engine.analysisengine"></a>
### `org.apache.uima.analysis_engine.AnalysisEngine`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `AnalysisEngine` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type   | Method                                                      | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|--------|-------------------------------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | `void` | `process`([`AnalysisProcessData`], [`ResultSpecification`]) | [`Deprecated`]: **`since`**=**`"2.3.1"`** | [`ResultNotSupportedException`], [`AnalysisEngineProcessException`] | ![Annotation modified] |


#### Fields

| Status    | Modifiers                 | Type       | Name                          | Annotations                               | Compatibility Changes |
|-----------|---------------------------|------------|-------------------------------|-------------------------------------------|-----------------------|
| Unchanged | `public` `static` `final` | [`String`] | `PARAM_CONFIG_PARAM_SETTINGS` | [`Deprecated`]: **`since`**=**`"2.5.0"`** | ![Annotation modified] |
| Unchanged | `public` `static` `final` | [`String`] | `PARAM_RESOURCE_MANAGER`      | [`Deprecated`]: **`since`**=**`"2.5.0"`** | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.analysis_engine.analysisprocessdata"></a>
### `org.apache.uima.analysis_engine.AnalysisProcessData`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                  | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|-----------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `AnalysisProcessData` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.1"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.textanalysisengine"></a>
### `org.apache.uima.analysis_engine.TextAnalysisEngine`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                 | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `TextAnalysisEngine` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.annotatorcontext"></a>
### `org.apache.uima.analysis_engine.annotator.AnnotatorContext`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `AnnotatorContext` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type            | Method                    | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|-----------------|---------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`SofaID[]`][1] | `getSofaMappings`()       | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | [`SofaID`]      | `mapToSofaID`([`String`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.annotatorcontextexception"></a>
### `org.apache.uima.analysis_engine.annotator.AnnotatorContextException`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name                        | Extends           | JDK    | Serialization | Compatibility Changes |
|-----------|-----------|-------|-----------------------------|-------------------|--------|---------------|-----------------------|
| Unchanged | `public`  | Class | `AnnotatorContextException` | [`UIMAException`] | JDK 17 | ![Compatible] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation                                    | Compatibility Changes |
|--------|-----------------------------------------------|-----------------------|
| Added  | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.annotator_implbase"></a>
### `org.apache.uima.analysis_engine.annotator.Annotator_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                 | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|----------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `Annotator_ImplBase` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.baseannotator"></a>
### `org.apache.uima.analysis_engine.annotator.BaseAnnotator`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name            | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|-----------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `BaseAnnotator` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type   | Method                             | Annotations                                   | Throws | Compatibility Changes |
|-----------|---------------------|----------|--------|------------------------------------|-----------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | `void` | `initialize`([`AnnotatorContext`]) | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`AnnotatorInitializationException`], [`AnnotatorConfigurationException`] | ![Annotation deprecated added] |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.genericannotator"></a>
### `org.apache.uima.analysis_engine.annotator.GenericAnnotator`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `GenericAnnotator` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.genericannotator_implbase"></a>
### `org.apache.uima.analysis_engine.annotator.GenericAnnotator_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                        | Extends                | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|-----------------------------|------------------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `GenericAnnotator_ImplBase` | [`Annotator_ImplBase`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.jtextannotator"></a>
### `org.apache.uima.analysis_engine.annotator.JTextAnnotator`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `JTextAnnotator` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.annotator.jtextannotator_implbase"></a>
### `org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                      | Extends                | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|---------------------------|------------------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `JTextAnnotator_ImplBase` | [`Annotator_ImplBase`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.analysis_engine.metadata.capabilitylanguageflow"></a>
### `org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                     | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|--------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `CapabilityLanguageFlow` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setCapabilityLanguageFlow`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.analysis_engine.metadata.fixedflow"></a>
### `org.apache.uima.analysis_engine.metadata.FixedFlow`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name        | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|-------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `FixedFlow` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                       | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setFixedFlow`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.cas.cas"></a>
### `org.apache.uima.cas.CAS`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name  | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|-------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CAS` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                 | Method                               | Annotations                                   | Throws                  | Compatibility Changes |
|-----------|---------------------|----------|----------------------|--------------------------------------|-----------------------------------------------|-------------------------|-----------------------|
| Unchanged | `public` `abstract` |          | [`FeatureValuePath`] | `createFeatureValuePath`([`String`]) | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`CASRuntimeException`] | ![Annotation deprecated added] |
| Unchanged | `public` `abstract` |          | [`SofaFS`]           | `createSofa`([`SofaID`], [`String`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`**     |                         | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | [`JCas`]             | `getJCas`([`SofaID`])                | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`CASException`]        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | [`SofaFS`]           | `getSofa`([`SofaID`])                | [`Deprecated`]: **`since`**=**`"2.0.0"`**     |                         | ![Annotation modified] |


#### Fields

| Status    | Modifiers                 | Type       | Name                     | Annotations                               | Compatibility Changes |
|-----------|---------------------------|------------|--------------------------|-------------------------------------------|-----------------------|
| Unchanged | `public` `static` `final` | [`String`] | `NAME_DEFAULT_TEXT_SOFA` | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.cas.featurepath"></a>
### `org.apache.uima.cas.FeaturePath`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name          | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `FeaturePath` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type          | Method                              | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|---------------|-------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`TypeClass`] | `getTypClass`([`FeatureStructure`]) | [`Deprecated`]: **`since`**=**`"3.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.cas.featurevaluepath"></a>
### `org.apache.uima.cas.FeatureValuePath`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `FeatureValuePath` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.3.1"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.cas.sofaid"></a>
### `org.apache.uima.cas.SofaID`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name     | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `SofaID` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.cas.admin.casfactory"></a>
### `org.apache.uima.cas.admin.CASFactory`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name         | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|--------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `CASFactory` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers         | Generics | Type       | Method                        | Annotations                               | Throws | Compatibility Changes |
|-----------|-------------------|----------|------------|-------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `static` `public` |          | [`CASMgr`] | `createCAS`(`int`, `boolean`) | [`Deprecated`]: **`since`**=**`"3.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.cas.admin.casmgr"></a>
### `org.apache.uima.cas.admin.CASMgr`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name     | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CASMgr` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type   | Method            | Annotations                               | Throws                | Compatibility Changes |
|-----------|---------------------|----------|--------|-------------------|-------------------------------------------|-----------------------|-----------------------|
| Unchanged | `public` `abstract` |          | `void` | `flush`()         | [`Deprecated`]: **`since`**=**`"2.3.1"`** | [`CASAdminException`] | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `setCAS`([`CAS`]) | [`Deprecated`]: **`since`**=**`"3.0.0"`** |                       | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.casinitializer"></a>
### `org.apache.uima.collection.CasInitializer`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CasInitializer` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.casinitializerdescription"></a>
### `org.apache.uima.collection.CasInitializerDescription`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                        | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|-----------------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CasInitializerDescription` | [`Object`] | JDK 17 | ![Compatible] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.casinitializer_implbase"></a>
### `org.apache.uima.collection.CasInitializer_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                      | Extends                           | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|---------------------------|-----------------------------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `CasInitializer_ImplBase` | [`ConfigurableResource_ImplBase`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.collectionreader"></a>
### `org.apache.uima.collection.CollectionReader`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CollectionReader` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type               | Method                                  | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|--------------------|-----------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`CasInitializer`] | `getCasInitializer`()                   | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void`             | `setCasInitializer`([`CasInitializer`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.collectionreader_implbase"></a>
### `org.apache.uima.collection.CollectionReader_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                        | Extends                           | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|-----------------------------|-----------------------------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `CollectionReader_ImplBase` | [`ConfigurableResource_ImplBase`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers | Generics | Type               | Method                                  | Annotations                               | Throws | Compatibility Changes |
|-----------|-----------|----------|--------------------|-----------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public`  |          | [`CasInitializer`] | `getCasInitializer`()                   | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |
| Unchanged | `public`  |          | `void`             | `setCasInitializer`([`CasInitializer`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.base_cpm.casdatacollectionreader"></a>
### `org.apache.uima.collection.base_cpm.CasDataCollectionReader`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                      | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CasDataCollectionReader` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                   | Method                                      | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|------------------------|---------------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`CasDataInitializer`] | `getCasDataInitializer`()                   | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void`                 | `setCasInitializer`([`CasDataInitializer`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.base_cpm.casdatainitializer"></a>
### `org.apache.uima.collection.base_cpm.CasDataInitializer`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                 | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CasDataInitializer` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.base_cpm.casdatainitializer_implbase"></a>
### `org.apache.uima.collection.base_cpm.CasDataInitializer_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name                          | Extends                           | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|-------------------------------|-----------------------------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `CasDataInitializer_ImplBase` | [`ConfigurableResource_ImplBase`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.metadata.cpecasprocessor"></a>
### `org.apache.uima.collection.metadata.CpeCasProcessor`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name              | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|-------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CpeCasProcessor` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type       | Method                      | Annotations                               | Throws                     | Compatibility Changes |
|-----------|---------------------|----------|------------|-----------------------------|-------------------------------------------|----------------------------|-----------------------|
| Unchanged | `public` `abstract` |          | [`String`] | `getDescriptor`()           | [`Deprecated`]: **`since`**=**`"3.3.0"`** |                            | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void`     | `setDescriptor`([`String`]) | [`Deprecated`]: **`since`**=**`"3.3.0"`** | [`CpeDescriptorException`] | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.metadata.cpecollectionreader"></a>
### `org.apache.uima.collection.metadata.CpeCollectionReader`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                  | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|-----------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CpeCollectionReader` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                                 | Method                                                    | Annotations                                   | Throws                     | Compatibility Changes |
|-----------|---------------------|----------|--------------------------------------|-----------------------------------------------------------|-----------------------------------------------|----------------------------|-----------------------|
| Unchanged | `public` `abstract` |          | [`CpeCollectionRe…erCasInitializer`] | `getCasInitializer`()                                     | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`CpeDescriptorException`] | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void`                               | `removeCasInitializer`()                                  | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |                            | ![Annotation deprecated added] |
| Unchanged | `public` `abstract` |          | `void`                               | `setCasInitializer`([`CpeCollectionRe…erCasInitializer`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`CpeDescriptorException`] | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.metadata.cpecollectionreadercasinitializer"></a>
### `org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                               | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|------------------------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CpeCollectionRe…erCasInitializer` | [`Object`] | JDK 17 | ![Compatible] | ![Annotation modified] |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"2.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.collection.metadata.cpedescription"></a>
### `org.apache.uima.collection.metadata.CpeDescription`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `CpeDescription` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                                 | Method                          | Annotations                               | Throws                     | Compatibility Changes |
|-----------|---------------------|----------|--------------------------------------|---------------------------------|-------------------------------------------|----------------------------|-----------------------|
| Unchanged | `public` `abstract` |          | [`CpeCollectionRe…erCasInitializer`] | `addCasInitializer`([`String`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** | [`CpeDescriptorException`] | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.collection.metadata.cpesofamappings"></a>
### `org.apache.uima.collection.metadata.CpeSofaMappings`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name              | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|-------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `CpeSofaMappings` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setSofaNameMappings`(~~[`CpeSofaMapping[]`][3]~~ &rarr; **[`CpeSofaMapping...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.flow.casflow_implbase"></a>
### `org.apache.uima.flow.CasFlow_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type  | Name               | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-------|--------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Class | `CasFlow_ImplBase` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers | Generics | Type   | Method            | Annotations                               | Throws | Compatibility Changes |
|-----------|-----------|----------|--------|-------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public`  |          | `void` | `setCas`([`CAS`]) | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.jcas.jcas"></a>
### `org.apache.uima.jcas.JCas`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name   | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `JCas` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type     | Method                | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|----------|-----------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`Sofa`] | `getSofa`([`SofaID`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.jcas.cas.arrayfsimpl"></a>
### `org.apache.uima.jcas.cas.ArrayFSImpl`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name          | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `ArrayFSImpl` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation modified] |


#### Generics

| Status    | Name | Extends              | Compatibility Changes |
|-----------|------|----------------------|-----------------------|
| Unchanged | `E`  | [`FeatureStructure`] | ![No changes]         |


#### Annotations

| Status   | Annotation                                | Compatibility Changes |
|----------|-------------------------------------------|-----------------------|
| Modified | [`Deprecated`]: **`since`**=**`"3.0.0"`** | ![No changes]         |

___

<a id="user-content-org.apache.uima.jcas.tcas.annotation"></a>
### `org.apache.uima.jcas.tcas.Annotation`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name         | Extends            | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|--------------|--------------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `Annotation` | [`AnnotationBase`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers | Generics | Type  | Method       | Annotations                               | Throws | Compatibility Changes |
|-----------|-----------|----------|-------|--------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public`  |          | `int` | `getStart`() | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.pear.tools.installationcontroller"></a>
### `org.apache.uima.pear.tools.InstallationController`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name                     | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|--------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `InstallationController` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers   | Generics | Type   | Method       | Annotations                                   | Throws | Compatibility Changes |
|-----------|-------------|----------|--------|--------------|-----------------------------------------------|--------|-----------------------|
| Unchanged | `protected` |          | `void` | `finalize`() | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |        | ![Annotation deprecated added] |

___

<a id="user-content-org.apache.uima.pear.tools.installationdescriptor"></a>
### `org.apache.uima.pear.tools.InstallationDescriptor`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name                     | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|-----------|-------|--------------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public`  | Class | `InstallationDescriptor` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers | Generics | Type   | Method                              | Annotations                               | Throws | Compatibility Changes |
|-----------|-----------|----------|--------|-------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public`  |          | `void` | `updateMainComponentId`([`String`]) | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.resource.customresourcespecifier"></a>
### `org.apache.uima.resource.CustomResourceSpecifier`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                      | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|---------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `CustomResourceSpecifier` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setParameters`(~~[`Parameter[]`][4]~~ &rarr; **[`Parameter...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.parameterizeddataresource"></a>
### `org.apache.uima.resource.ParameterizedDataResource`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                        | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|---------------------|-----------|-----------------------------|------------|--------|---------------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ParameterizedDataResource` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type             | Method                                                          | Annotations | Throws                              | Compatibility Changes |
|----------|---------------------|----------|------------------|-----------------------------------------------------------------|-------------|-------------------------------------|-----------------------|
| Modified | `public` `abstract` |          | [`DataResource`] | `getDataResource`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             | [`ResourceInitializationException`] | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.relativepathresolver"></a>
### `org.apache.uima.resource.RelativePathResolver`

- [X] Binary-compatible
- [ ] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                   | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|---------------------|-----------|------------------------|------------|--------|---------------------|-----------------------|
| Modified | `public` `abstract` | Interface | `RelativePathResolver` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers                   | Generics | Type              | Method                                | Annotations                                   | Throws                    | Compatibility Changes |
|-----------|-----------------------------|----------|-------------------|---------------------------------------|-----------------------------------------------|---------------------------|-----------------------|
| Unchanged | `public` `abstract`         |          | [`String`]        | `getDataPath`()                       | [`Deprecated`]: **`since`**=**`"3.3.0"`**     |                           | ![Annotation modified] |
| Unchanged | `public` `abstract`         |          | [`List<String>`]  | `getDataPathElements`()               | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |                           | ![Annotation deprecated added] |
| Added     | **`public`** **`abstract`** |          | **[`List<URL>`]** | **`getDataPathUrls`**()               |                                               |                           | ![Method added to interface] |
| Unchanged | `public` `abstract`         |          | [`URL`]           | `resolveRelativePath`([`URL`])        | **[`Deprecated`]**                            |                           | ![Annotation deprecated added] |
| Added     | **`public`** **`abstract`** |          | **[`URL`]**       | **`resolveRelativePath`**([`String`]) |                                               |                           | ![Method added to interface] |
| Unchanged | `public` `abstract`         |          | `void`            | `setDataPath`([`String`])             | [`Deprecated`]: **`since`**=**`"3.3.0"`**     | [`MalformedURLException`] | ![Annotation modified] |
| Added     | **`public`** **`abstract`** |          | **`void`**        | **`setDataPathElements`**([`URL...`]) |                                               |                           | ![Method added to interface] |

___

<a id="user-content-org.apache.uima.resource.resourcecreationspecifier"></a>
### `org.apache.uima.resource.ResourceCreationSpecifier`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                        | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|-----------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ResourceCreationSpecifier` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setExternalResourceDependencies`(~~[`ExternalResourceDependency[]`][5]~~ &rarr; **[`ExternalResourceDependency...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.resourcemanager"></a>
### `org.apache.uima.resource.ResourceManager`

- [X] Binary-compatible
- [ ] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name              | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|---------------------|-----------|-------------------|------------|--------|---------------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ResourceManager` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers                   | Generics | Type                       | Method                            | Annotations                                   | Throws                      | Compatibility Changes |
|-----------|-----------------------------|----------|----------------------------|-----------------------------------|-----------------------------------------------|-----------------------------|-----------------------|
| Unchanged | `public` `abstract`         |          | [`String`]                 | `getDataPath`()                   | [`Deprecated`]: **`since`**=**`"3.3.0"`**     |                             | ![Annotation modified] |
| Unchanged | `public` `abstract`         |          | [`List<String>`]           | `getDataPathElements`()           | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** |                             | ![Annotation deprecated added] |
| Added     | **`public`** **`abstract`** |          | **[`List<URL>`]**          | **`getDataPathUrls`**()           |                                               |                             | ![Method added to interface] |
| Unchanged | `public` `abstract`         |          | [`Map<String, XMLizable>`] | `getImportCache`()                | [`Deprecated`]: **`since`**=**`"3.3.0"`**     |                             | ![Annotation modified] |
| Modified  | `public` `abstract`         |          | [`Object`]                 | `getResource`([`String`], ~~[`String[]`][2]~~ &rarr; **[`String...`]**) |         | [`ResourceAccessException`] | ![Method now varargs] |
| Modified  | `public` `abstract`         |          | [`InputStream`]            | `getResourceAsStream`([`String`], ~~[`String[]`][2]~~ &rarr; **[`String...`]**) |  | [`ResourceAccessException`] | ![Method now varargs] |
| Modified  | `public` `abstract`         |          | [`URL`]                    | `getResourceURL`([`String`], ~~[`String[]`][2]~~ &rarr; **[`String...`]**) |      | [`ResourceAccessException`] | ![Method now varargs] |
| Unchanged | `public` `abstract`         |          | `void`                     | `setDataPath`([`String`])         | [`Deprecated`]: **`since`**=**`"3.3.0"`**     | [`MalformedURLException`]   | ![Annotation modified] |
| Added     | **`public`** **`abstract`** |          | **`void`**                 | **`setDataPathUrls`**([`URL...`]) |                                               |                             | ![Method added to interface] |

___

<a id="user-content-org.apache.uima.resource.urispecifier"></a>
### `org.apache.uima.resource.URISpecifier`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name           | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|----------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `URISpecifier` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setParameters`(~~[`Parameter[]`][4]~~ &rarr; **[`Parameter...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.capability"></a>
### `org.apache.uima.resource.metadata.Capability`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name         | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|--------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `Capability` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                         | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|----------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setInputSofas`(~~[`String[]`][2]~~ &rarr; **[`String...`]**)  |             |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setInputs`(~~[`TypeOrFeature[]`][6]~~ &rarr; **[`TypeOrFeature...`]**) |    |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setLanguagesSupported`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |      |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setMimeTypesSupported`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |      |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setOutputSofas`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setOutputs`(~~[`TypeOrFeature[]`][6]~~ &rarr; **[`TypeOrFeature...`]**) |   |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setPreconditions`(~~[`Precondition[]`][7]~~ &rarr; **[`Precondition...`]**) |  |     | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.configurationgroup"></a>
### `org.apache.uima.resource.metadata.ConfigurationGroup`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                 | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|----------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ConfigurationGroup` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                   | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|----------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setConfigurationParameters`(~~[`ConfigurationParameter[]`][8]~~ &rarr; **[`ConfigurationParameter...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setNames`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.configurationparameter"></a>
### `org.apache.uima.resource.metadata.ConfigurationParameter`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                     | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|--------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ConfigurationParameter` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                       | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setOverrides`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.configurationparameterdeclarations"></a>
### `org.apache.uima.resource.metadata.ConfigurationParameterDeclarations`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                               | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|------------------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ConfigurationPa…eterDeclarations` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setCommonParameters`(~~[`ConfigurationParameter[]`][8]~~ &rarr; **[`ConfigurationParameter...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setConfigurationGroups`(~~[`ConfigurationGroup[]`][9]~~ &rarr; **[`ConfigurationGroup...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setConfigurationParameters`(~~[`ConfigurationParameter[]`][8]~~ &rarr; **[`ConfigurationParameter...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.configurationparametersettings"></a>
### `org.apache.uima.resource.metadata.ConfigurationParameterSettings`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                             | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|----------------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ConfigurationParameterSettings` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setParameterSettings`(~~[`NameValuePair[]`][10]~~ &rarr; **[`NameValuePair...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.fsindexcollection"></a>
### `org.apache.uima.resource.metadata.FsIndexCollection`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|---------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `FsIndexCollection` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                      | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|-------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setFsIndexes`(~~[`FsIndexDescription[]`][11]~~ &rarr; **[`FsIndexDescription...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setImports`(~~[`Import[]`][12]~~ &rarr; **[`Import...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.fsindexdescription"></a>
### `org.apache.uima.resource.metadata.FsIndexDescription`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                 | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|----------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `FsIndexDescription` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setKeys`(~~[`FsIndexKeyDescription[]`][13]~~ &rarr; **[`FsIndexKeyDescription...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.languageprecondition"></a>
### `org.apache.uima.resource.metadata.LanguagePrecondition`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                   | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `LanguagePrecondition` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                       | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setLanguages`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.metadataobject"></a>
### `org.apache.uima.resource.metadata.MetaDataObject`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization | Compatibility Changes |
|-----------|---------------------|-----------|------------------|------------|--------|---------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `MetaDataObject` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                    | Method             | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|-------------------------|--------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`List<NameClassPair>`] | `listAttributes`() | [`Deprecated`]: **`since`**=**`"3.3.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.resource.metadata.mimetypeprecondition"></a>
### `org.apache.uima.resource.metadata.MimeTypePrecondition`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                   | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `MimeTypePrecondition` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                       | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setMimeTypes`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.processingresourcemetadata"></a>
### `org.apache.uima.resource.metadata.ProcessingResourceMetaData`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                         | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|------------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ProcessingResourceMetaData` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setCapabilities`(~~[`Capability[]`][14]~~ &rarr; **[`Capability...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setFsIndexes`(~~[`FsIndexDescription[]`][11]~~ &rarr; **[`FsIndexDescription...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.resourcemanagerconfiguration"></a>
### `org.apache.uima.resource.metadata.ResourceManagerConfiguration`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                           | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|--------------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `ResourceManagerConfiguration` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type       | Method                                                      | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|------------|-------------------------------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | [`Import`] | `getImport`()                                               | [`Deprecated`]: **`since`**=**`"3.3.0"`** |        | ![Annotation modified] |
| Modified  | `public` `abstract` |          | `void`     | `setExternalResourceBindings`(~~[`ExternalResourceBinding[]`][15]~~ &rarr; **[`ExternalResourceBinding...`]**) |  |  | ![Method now varargs] |
| Modified  | `public` `abstract` |          | `void`     | `setExternalResources`(~~[`ExternalResourceDescription[]`][16]~~ &rarr; **[`ExternalResourceDescription...`]**) |  |  | ![Method now varargs] |
| Unchanged | `public` `abstract` |          | `void`     | `setImport`([`Import`])                                     | [`Deprecated`]: **`since`**=**`"3.3.0"`** |        | ![Annotation modified] |
| Modified  | `public` `abstract` |          | `void`     | `setImports`(~~[`Import[]`][12]~~ &rarr; **[`Import...`]**) |                                           |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.typedescription"></a>
### `org.apache.uima.resource.metadata.TypeDescription`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name              | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|-------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `TypeDescription` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|--------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setAllowedValues`(~~[`AllowedValue[]`][17]~~ &rarr; **[`AllowedValue...`]**) |  |  | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setFeatures`(~~[`FeatureDescription[]`][18]~~ &rarr; **[`FeatureDescription...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.typepriorities"></a>
### `org.apache.uima.resource.metadata.TypePriorities`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name             | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `TypePriorities` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                      | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|-------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setImports`(~~[`Import[]`][12]~~ &rarr; **[`Import...`]**) |             |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setPriorityLists`(~~[`TypePriorityList[]`][19]~~ &rarr; **[`TypePriorityList...`]**) |  |  | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.typeprioritylist"></a>
### `org.apache.uima.resource.metadata.TypePriorityList`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name               | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|--------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `TypePriorityList` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                   | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|----------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setTypes`(~~[`String[]`][2]~~ &rarr; **[`String...`]**) |             |        | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.resource.metadata.typesystemdescription"></a>
### `org.apache.uima.resource.metadata.TypeSystemDescription`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers           | Type      | Name                    | Extends    | JDK    | Serialization | Compatibility Changes |
|----------|---------------------|-----------|-------------------------|------------|--------|---------------|-----------------------|
| Modified | `public` `abstract` | Interface | `TypeSystemDescription` | [`Object`] | JDK 17 | ![Compatible] | ![No changes]         |


#### Methods

| Status   | Modifiers           | Generics | Type   | Method                                                      | Annotations | Throws | Compatibility Changes |
|----------|---------------------|----------|--------|-------------------------------------------------------------|-------------|--------|-----------------------|
| Modified | `public` `abstract` |          | `void` | `setImports`(~~[`Import[]`][12]~~ &rarr; **[`Import...`]**) |             |        | ![Method now varargs] |
| Modified | `public` `abstract` |          | `void` | `setTypes`(~~[`TypeDescription[]`][20]~~ &rarr; **[`TypeDescription...`]**) |  |   | ![Method now varargs] |

___

<a id="user-content-org.apache.uima.spi.fsindexcollectionprovider"></a>
### `org.apache.uima.spi.FsIndexCollectionProvider`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                        | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|-----------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `FsIndexCollectionProvider` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation         | Compatibility Changes |
|--------|--------------------|-----------------------|
| Added  | **[`Deprecated`]** | ![No changes]         |

___

<a id="user-content-org.apache.uima.spi.jcasclassprovider"></a>
### `org.apache.uima.spi.JCasClassProvider`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `JCasClassProvider` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation         | Compatibility Changes |
|--------|--------------------|-----------------------|
| Added  | **[`Deprecated`]** | ![No changes]         |

___

<a id="user-content-org.apache.uima.spi.typeprioritiesprovider"></a>
### `org.apache.uima.spi.TypePrioritiesProvider`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                     | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|--------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `TypePrioritiesProvider` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation         | Compatibility Changes |
|--------|--------------------|-----------------------|
| Added  | **[`Deprecated`]** | ![No changes]         |

___

<a id="user-content-org.apache.uima.spi.typesystemdescriptionprovider"></a>
### `org.apache.uima.spi.TypeSystemDescriptionProvider`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name                            | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|---------------------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `TypeSystemDescriptionProvider` | [`Object`] | JDK 17 | ![Not serializable] | ![Annotation deprecated added] |


#### Annotations

| Status | Annotation         | Compatibility Changes |
|--------|--------------------|-----------------------|
| Added  | **[`Deprecated`]** | ![No changes]         |

___

<a id="user-content-org.apache.uima.spi.typesystemprovider"></a>
### `org.apache.uima.spi.TypeSystemProvider`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status | Modifiers                   | Type          | Name                     | Extends        | JDK        | Serialization       | Compatibility Changes |
|--------|-----------------------------|---------------|--------------------------|----------------|------------|---------------------|-----------------------|
| Added  | **`public`** **`abstract`** | **Interface** | **`TypeSystemProvider`** | **[`Object`]** | **JDK 17** | ![Not serializable] | ![Interface added]    |


#### Implemented Interfaces

| Status | Interface                             | Compatibility Changes |
|--------|---------------------------------------|-----------------------|
| Added  | **[`FsIndexCollectionProvider`]**     | ![No changes]         |
| Added  | **[`JCasClassProvider`]**             | ![No changes]         |
| Added  | **[`TypePrioritiesProvider`]**        | ![No changes]         |
| Added  | **[`TypeSystemDescriptionProvider`]** | ![No changes]         |


#### Methods

| Status | Modifiers    | Generics | Type                                | Method                             | Annotations | Throws | Compatibility Changes |
|--------|--------------|----------|-------------------------------------|------------------------------------|-------------|--------|-----------------------|
| Added  | **`public`** |          | **[`Optional<URL>`]**               | **`findResourceUrl`**([`String`])  |             |        | ![No changes]         |
| Added  | **`public`** |          | **[`List<FsIndexCollection>`]**     | **`listFsIndexCollections`**()     |             |        | ![No changes]         |
| Added  | **`public`** |          | **[`List<Class<TOP>>`]**            | **`listJCasClasses`**()            |             |        | ![No changes]         |
| Added  | **`public`** |          | **[`List<TypePriorities>`]**        | **`listTypePriorities`**()         |             |        | ![No changes]         |
| Added  | **`public`** |          | **[`List<TypeSystemDescription>`]** | **`listTypeSystemDescriptions`**() |             |        | ![No changes]         |

___

<a id="user-content-org.apache.uima.spi.typesystemprovider_implbase"></a>
### `org.apache.uima.spi.TypeSystemProvider_ImplBase`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status | Modifiers                   | Type      | Name                              | Extends        | JDK        | Serialization       | Compatibility Changes |
|--------|-----------------------------|-----------|-----------------------------------|----------------|------------|---------------------|-----------------------|
| Added  | **`public`** **`abstract`** | **Class** | **`TypeSystemProvider_ImplBase`** | **[`Object`]** | **JDK 17** | ![Not serializable] | ![Interface added]    |


#### Implemented Interfaces

| Status | Interface                             | Compatibility Changes |
|--------|---------------------------------------|-----------------------|
| Added  | **[`FsIndexCollectionProvider`]**     | ![No changes]         |
| Added  | **[`JCasClassProvider`]**             | ![No changes]         |
| Added  | **[`TypePrioritiesProvider`]**        | ![No changes]         |
| Added  | **[`TypeSystemDescriptionProvider`]** | ![No changes]         |
| Added  | **[`TypeSystemProvider`]**            | ![No changes]         |


#### Constructors

| Status | Modifiers    | Generics | Constructor                         | Annotations | Throws | Compatibility Changes |
|--------|--------------|----------|-------------------------------------|-------------|--------|-----------------------|
| Added  | **`public`** |          | **`TypeSystemProvider_ImplBase`**() |             |        | ![No changes]         |


#### Methods

| Status | Modifiers       | Generics | Type                                | Method                                             | Annotations | Throws | Compatibility Changes |
|--------|-----------------|----------|-------------------------------------|----------------------------------------------------|-------------|--------|-----------------------|
| Added  | **`public`**    |          | **[`Optional<URL>`]**               | **`findResourceUrl`**([`String`])                  |             |        | ![Method added to public class] |
| Added  | **`public`**    |          | **[`List<FsIndexCollection>`]**     | **`listFsIndexCollections`**()                     |             |        | ![Method added to public class] |
| Added  | **`public`**    |          | **[`List<Class<TOP>>`]**            | **`listJCasClasses`**()                            |             |        | ![Method added to public class] |
| Added  | **`public`**    |          | **[`List<TypePriorities>`]**        | **`listTypePriorities`**()                         |             |        | ![Method added to public class] |
| Added  | **`public`**    |          | **[`List<TypeSystemDescription>`]** | **`listTypeSystemDescriptions`**()                 |             |        | ![Method added to public class] |
| Added  | **`protected`** |          | **`void`**                          | **`setFsIndexCollectionLocations`**([`String...`]) |             |        | ![No changes]         |
| Added  | **`protected`** |          | **`void`**                          | **`setTypePrioritiesLocations`**([`String...`])    |             |        | ![No changes]         |
| Added  | **`protected`** |          | **`void`**                          | **`setTypeSystemLocations`**([`String...`])        |             |        | ![No changes]         |

___

<a id="user-content-org.apache.uima.uimacpp.cppuimajengine"></a>
### `org.apache.uima.uimacpp.CppUimajEngine`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `CppUimajEngine` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers   | Generics | Type   | Method       | Annotations                                   | Throws        | Compatibility Changes |
|-----------|-------------|----------|--------|--------------|-----------------------------------------------|---------------|-----------------------|
| Unchanged | `protected` |          | `void` | `finalize`() | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`Throwable`] | ![Annotation deprecated added] |

___

<a id="user-content-org.apache.uima.uimacpp.uimacppanalysiscomponent"></a>
### `org.apache.uima.uimacpp.UimacppAnalysisComponent`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name                       | Extends                        | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|----------------------------|--------------------------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `UimacppAnalysisComponent` | [`AnalysisComponent_ImplBase`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers   | Generics | Type   | Method       | Annotations                                   | Throws        | Compatibility Changes |
|-----------|-------------|----------|--------|--------------|-----------------------------------------------|---------------|-----------------------|
| Unchanged | `protected` |          | `void` | `finalize`() | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`Throwable`] | ![Annotation deprecated added] |

___

<a id="user-content-org.apache.uima.uimacpp.uimacppengine"></a>
### `org.apache.uima.uimacpp.UimacppEngine`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name            | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|-----------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `UimacppEngine` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers   | Generics | Type   | Method       | Annotations                                   | Throws        | Compatibility Changes |
|-----------|-------------|----------|--------|--------------|-----------------------------------------------|---------------|-----------------------|
| Unchanged | `protected` |          | `void` | `finalize`() | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`Throwable`] | ![Annotation deprecated added] |

___

<a id="user-content-org.apache.uima.util.logger"></a>
### `org.apache.uima.util.Logger`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name     | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|----------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `Logger` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type   | Method                                          | Annotations                               | Throws | Compatibility Changes |
|-----------|---------------------|----------|--------|-------------------------------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public` `abstract` |          | `void` | `log`([`String`])                               | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `log`([`String`], [`String`], [`Object[]`][21]) | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `logException`([`Exception`])                   | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `setOutputStream`([`PrintStream`])              | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `setOutputStream`([`OutputStream`])             | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | `void` | `setResourceManager`([`ResourceManager`])       | [`Deprecated`]: **`since`**=**`"3.3.0"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.util.typesystemutil"></a>
### `org.apache.uima.util.TypeSystemUtil`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status   | Modifiers | Type  | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|----------|-----------|-------|------------------|------------|--------|---------------------|-----------------------|
| Modified | `public`  | Class | `TypeSystemUtil` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status | Modifiers                 | Generics | Type                            | Method                          | Annotations | Throws | Compatibility Changes |
|--------|---------------------------|----------|---------------------------------|---------------------------------|-------------|--------|-----------------------|
| Added  | **`static`** **`public`** |          | **`boolean`**                   | **`isFeatureName`**([`String`]) |             |        | ![Method added to public class] |
| Added  | **`static`** **`public`** |          | **`boolean`**                   | **`isTypeName`**([`String`])    |             |        | ![Method added to public class] |
| Added  | **`static`** **`public`** |          | **[`List<FsIndexCollection>`]** | **`loadFsIndexCollectionsFromClasspath`**([`Class<?>`], [`String...`]) |  |  | ![Method added to public class] |
| Added  | **`static`** **`public`** |          | **[`List<TypePriorities>`]**    | **`loadTypePrioritiesFromClasspath`**([`Class<?>`], [`String...`]) |  |  | ![Method added to public class] |

___

<a id="user-content-org.apache.uima.util.xmlinputsource"></a>
### `org.apache.uima.util.XMLInputSource`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers | Type  | Name             | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|-----------|-------|------------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public`  | Class | `XMLInputSource` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers | Generics | Type     | Method                  | Annotations                               | Throws | Compatibility Changes |
|-----------|-----------|----------|----------|-------------------------|-------------------------------------------|--------|-----------------------|
| Unchanged | `public`  |          | [`File`] | `getRelativePathBase`() | [`Deprecated`]: **`since`**=**`"2.3.1"`** |        | ![Annotation modified] |

___

<a id="user-content-org.apache.uima.util.xmlparser"></a>
### `org.apache.uima.util.XMLParser`

- [X] Binary-compatible
- [X] Source-compatible
- [X] Serialization-compatible

| Status    | Modifiers           | Type      | Name        | Extends    | JDK    | Serialization       | Compatibility Changes |
|-----------|---------------------|-----------|-------------|------------|--------|---------------------|-----------------------|
| Unchanged | `public` `abstract` | Interface | `XMLParser` | [`Object`] | JDK 17 | ![Not serializable] | ![No changes]         |


#### Methods

| Status    | Modifiers           | Generics | Type                          | Method                                                        | Annotations                                   | Throws                  | Compatibility Changes |
|-----------|---------------------|----------|-------------------------------|---------------------------------------------------------------|-----------------------------------------------|-------------------------|-----------------------|
| Unchanged | `public` `abstract` |          | [`CasInitializerDescription`] | `parseCasInitializerDescription`([`XMLInputSource`])          | **[`Deprecated`]**: **`since`**=**`"3.6.0"`** | [`InvalidXMLException`] | ![Annotation deprecated added] |
| Unchanged | `public` `abstract` |          | [`TaeDescription`]            | `parseTaeDescription`([`XMLInputSource`])                     | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`InvalidXMLException`] | ![Annotation modified] |
| Unchanged | `public` `abstract` |          | [`TaeDescription`]            | `parseTaeDescription`([`XMLInputSource`], [`ParsingOptions`]) | [`Deprecated`]: **`since`**=**`"2.0.0"`**     | [`InvalidXMLException`] | ![Annotation modified] |


</details>


> [!WARNING]
>
> Certain classes, i.e. superclasses and interfaces that could not be found on the classpath were ignored.
>
> Hence changes caused by these superclasses and interfaces are not reflected in the output.

___

*Generated on: 2024-11-22 17:41:02.291+0100*.

[1]: # "org.apache.uima.cas.SofaID[]"
[2]: # "java.lang.String[]"
[3]: # "org.apache.uima.collection.metadata.CpeSofaMapping[]"
[4]: # "org.apache.uima.resource.Parameter[]"
[5]: # "org.apache.uima.resource.ExternalResourceDependency[]"
[6]: # "org.apache.uima.analysis_engine.TypeOrFeature[]"
[7]: # "org.apache.uima.resource.metadata.Precondition[]"
[8]: # "org.apache.uima.resource.metadata.ConfigurationParameter[]"
[9]: # "org.apache.uima.resource.metadata.ConfigurationGroup[]"
[10]: # "org.apache.uima.resource.metadata.NameValuePair[]"
[11]: # "org.apache.uima.resource.metadata.FsIndexDescription[]"
[12]: # "org.apache.uima.resource.metadata.Import[]"
[13]: # "org.apache.uima.resource.metadata.FsIndexKeyDescription[]"
[14]: # "org.apache.uima.resource.metadata.Capability[]"
[15]: # "org.apache.uima.resource.metadata.ExternalResourceBinding[]"
[16]: # "org.apache.uima.resource.ExternalResourceDescription[]"
[17]: # "org.apache.uima.resource.metadata.AllowedValue[]"
[18]: # "org.apache.uima.resource.metadata.FeatureDescription[]"
[19]: # "org.apache.uima.resource.metadata.TypePriorityList[]"
[20]: # "org.apache.uima.resource.metadata.TypeDescription[]"
[21]: # "java.lang.Object[]"
[Annotation deprecated added]: https://img.shields.io/badge/Annotation_deprecated_added-orange "Annotation deprecated added"
[Annotation modified]: https://img.shields.io/badge/Annotation_modified-yellow "Annotation modified"
[Compatible]: https://img.shields.io/badge/Compatible-green "Compatible"
[Interface added]: https://img.shields.io/badge/Interface_added-orange "Interface added"
[Method added to interface]: https://img.shields.io/badge/Method_added_to_interface-orange "Method added to interface"
[Method added to public class]: https://img.shields.io/badge/Method_added_to_public_class-yellow "Method added to public class"
[Method new default]: https://img.shields.io/badge/Method_new_default-orange "Method new default"
[Method now varargs]: https://img.shields.io/badge/Method_now_varargs-orange "Method now varargs"
[No changes]: https://img.shields.io/badge/No_changes-green "No changes"
[Not serializable]: https://img.shields.io/badge/Not_serializable-green "Not serializable"
[`AllowedValue...`]: # "org.apache.uima.resource.metadata.AllowedValue..."
[`AnalysisComponent_ImplBase`]: # "org.apache.uima.analysis_component.AnalysisComponent_ImplBase"
[`AnalysisEngineProcessException`]: # "org.apache.uima.analysis_engine.AnalysisEngineProcessException"
[`AnalysisProcessData`]: # "org.apache.uima.analysis_engine.AnalysisProcessData"
[`AnnotationBase`]: # "org.apache.uima.jcas.cas.AnnotationBase"
[`AnnotatorConfigurationException`]: # "org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException"
[`AnnotatorContext`]: # "org.apache.uima.analysis_engine.annotator.AnnotatorContext"
[`AnnotatorInitializationException`]: # "org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException"
[`Annotator_ImplBase`]: # "org.apache.uima.analysis_engine.annotator.Annotator_ImplBase"
[`CASAdminException`]: # "org.apache.uima.cas.admin.CASAdminException"
[`CASException`]: # "org.apache.uima.cas.CASException"
[`CASMgr`]: # "org.apache.uima.cas.admin.CASMgr"
[`CASRuntimeException`]: # "org.apache.uima.cas.CASRuntimeException"
[`CAS`]: # "org.apache.uima.cas.CAS"
[`Capability...`]: # "org.apache.uima.resource.metadata.Capability..."
[`CasDataInitializer`]: # "org.apache.uima.collection.base_cpm.CasDataInitializer"
[`CasInitializerDescription`]: # "org.apache.uima.collection.CasInitializerDescription"
[`CasInitializer`]: # "org.apache.uima.collection.CasInitializer"
[`Class<?>`]: # "java.lang.Class<?>"
[`ConfigurableResource_ImplBase`]: # "org.apache.uima.resource.ConfigurableResource_ImplBase"
[`ConfigurationGroup...`]: # "org.apache.uima.resource.metadata.ConfigurationGroup..."
[`ConfigurationManager`]: # "org.apache.uima.resource.ConfigurationManager"
[`ConfigurationParameter...`]: # "org.apache.uima.resource.metadata.ConfigurationParameter..."
[`CpeCollectionRe…erCasInitializer`]: # "org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer"
[`CpeDescriptorException`]: # "org.apache.uima.collection.metadata.CpeDescriptorException"
[`CpeSofaMapping...`]: # "org.apache.uima.collection.metadata.CpeSofaMapping..."
[`DataResource`]: # "org.apache.uima.resource.DataResource"
[`Deprecated`]: # "java.lang.Deprecated"
[`Exception`]: # "java.lang.Exception"
[`ExternalResourceBinding...`]: # "org.apache.uima.resource.metadata.ExternalResourceBinding..."
[`ExternalResourceDependency...`]: # "org.apache.uima.resource.ExternalResourceDependency..."
[`ExternalResourceDescription...`]: # "org.apache.uima.resource.ExternalResourceDescription..."
[`FeatureDescription...`]: # "org.apache.uima.resource.metadata.FeatureDescription..."
[`FeatureStructure`]: # "org.apache.uima.cas.FeatureStructure"
[`FeatureValuePath`]: # "org.apache.uima.cas.FeatureValuePath"
[`File`]: # "java.io.File"
[`FsIndexCollectionProvider`]: # "org.apache.uima.spi.FsIndexCollectionProvider"
[`FsIndexDescription...`]: # "org.apache.uima.resource.metadata.FsIndexDescription..."
[`FsIndexKeyDescription...`]: # "org.apache.uima.resource.metadata.FsIndexKeyDescription..."
[`Import...`]: # "org.apache.uima.resource.metadata.Import..."
[`Import`]: # "org.apache.uima.resource.metadata.Import"
[`InputStream`]: # "java.io.InputStream"
[`InvalidXMLException`]: # "org.apache.uima.util.InvalidXMLException"
[`JCasClassProvider`]: # "org.apache.uima.spi.JCasClassProvider"
[`JCas`]: # "org.apache.uima.jcas.JCas"
[`List<Class<TOP>>`]: # "java.util.List<java.lang.Class<org.apache.uima.jcas.cas.TOP>>"
[`List<FsIndexCollection>`]: # "java.util.List<org.apache.uima.resource.metadata.FsIndexCollection>"
[`List<NameClassPair>`]: # "java.util.List<org.apache.uima.util.NameClassPair>"
[`List<String>`]: # "java.util.List<java.lang.String>"
[`List<TypePriorities>`]: # "java.util.List<org.apache.uima.resource.metadata.TypePriorities>"
[`List<TypeSystemDescription>`]: # "java.util.List<org.apache.uima.resource.metadata.TypeSystemDescription>"
[`List<URL>`]: # "java.util.List<java.net.URL>"
[`Logger`]: # "org.apache.uima.util.Logger"
[`MalformedURLException`]: # "java.net.MalformedURLException"
[`Map<String, Object>`]: # "java.util.Map<java.lang.String, java.lang.Object>"
[`Map<String, XMLizable>`]: # "java.util.Map<java.lang.String, org.apache.uima.util.XMLizable>"
[`NameValuePair...`]: # "org.apache.uima.resource.metadata.NameValuePair..."
[`Object`]: # "java.lang.Object"
[`Optional<URL>`]: # "java.util.Optional<java.net.URL>"
[`OutputStream`]: # "java.io.OutputStream"
[`Parameter...`]: # "org.apache.uima.resource.Parameter..."
[`ParsingOptions`]: # "org.apache.uima.util.XMLParser$ParsingOptions"
[`Precondition...`]: # "org.apache.uima.resource.metadata.Precondition..."
[`PrintStream`]: # "java.io.PrintStream"
[`ResourceAccessException`]: # "org.apache.uima.resource.ResourceAccessException"
[`ResourceInitializationException`]: # "org.apache.uima.resource.ResourceInitializationException"
[`ResourceManager`]: # "org.apache.uima.resource.ResourceManager"
[`ResourceSpecifier`]: # "org.apache.uima.resource.ResourceSpecifier"
[`ResultNotSupportedException`]: # "org.apache.uima.analysis_engine.ResultNotSupportedException"
[`ResultSpecification`]: # "org.apache.uima.analysis_engine.ResultSpecification"
[`SofaFS`]: # "org.apache.uima.cas.SofaFS"
[`SofaID`]: # "org.apache.uima.cas.SofaID"
[`Sofa`]: # "org.apache.uima.jcas.cas.Sofa"
[`String...`]: # "java.lang.String..."
[`String`]: # "java.lang.String"
[`TaeDescription`]: # "org.apache.uima.analysis_engine.TaeDescription"
[`TextAnalysisEngine`]: # "org.apache.uima.analysis_engine.TextAnalysisEngine"
[`Throwable`]: # "java.lang.Throwable"
[`TypeClass`]: # "org.apache.uima.cas.TypeClass"
[`TypeDescription...`]: # "org.apache.uima.resource.metadata.TypeDescription..."
[`TypeOrFeature...`]: # "org.apache.uima.analysis_engine.TypeOrFeature..."
[`TypePrioritiesProvider`]: # "org.apache.uima.spi.TypePrioritiesProvider"
[`TypePriorityList...`]: # "org.apache.uima.resource.metadata.TypePriorityList..."
[`TypeSystemDescriptionProvider`]: # "org.apache.uima.spi.TypeSystemDescriptionProvider"
[`TypeSystemProvider`]: # "org.apache.uima.spi.TypeSystemProvider"
[`UIMAException`]: # "org.apache.uima.UIMAException"
[`URL...`]: # "java.net.URL..."
[`URL`]: # "java.net.URL"
[`UimaContextAdminBuilder`]: # "org.apache.uima.UimaContextAdminBuilder"
[`UimaContextAdmin`]: # "org.apache.uima.UimaContextAdmin"
[`XMLInputSource`]: # "org.apache.uima.util.XMLInputSource"
[org.apache.uima.Constants]: #user-content-org.apache.uima.constants
[org.apache.uima.List_of_ints]: #user-content-org.apache.uima.list_of_ints
[org.apache.uima.UIMAFramework]: #user-content-org.apache.uima.uimaframework
[org.apache.uima.UimaContext]: #user-content-org.apache.uima.uimacontext
[org.apache.uima.UimaContextAdmin]: #user-content-org.apache.uima.uimacontextadmin
[org.apache.uima.UimaContextAdminBuilder]: #user-content-org.apache.uima.uimacontextadminbuilder
[org.apache.uima.analysis_engine.AnalysisEngine]: #user-content-org.apache.uima.analysis_engine.analysisengine
[org.apache.uima.analysis_engine.AnalysisProcessData]: #user-content-org.apache.uima.analysis_engine.analysisprocessdata
[org.apache.uima.analysis_engine.TextAnalysisEngine]: #user-content-org.apache.uima.analysis_engine.textanalysisengine
[org.apache.uima.analysis_engine.annotator.AnnotatorContext]: #user-content-org.apache.uima.analysis_engine.annotator.annotatorcontext
[org.apache.uima.analysis_engine.annotator.AnnotatorContextException]: #user-content-org.apache.uima.analysis_engine.annotator.annotatorcontextexception
[org.apache.uima.analysis_engine.annotator.Annotator_ImplBase]: #user-content-org.apache.uima.analysis_engine.annotator.annotator_implbase
[org.apache.uima.analysis_engine.annotator.BaseAnnotator]: #user-content-org.apache.uima.analysis_engine.annotator.baseannotator
[org.apache.uima.analysis_engine.annotator.GenericAnnotator]: #user-content-org.apache.uima.analysis_engine.annotator.genericannotator
[org.apache.uima.analysis_engine.annotator.GenericAnnotator_ImplBase]: #user-content-org.apache.uima.analysis_engine.annotator.genericannotator_implbase
[org.apache.uima.analysis_engine.annotator.JTextAnnotator]: #user-content-org.apache.uima.analysis_engine.annotator.jtextannotator
[org.apache.uima.analysis_engine.annotator.JTextAnnotator_ImplBase]: #user-content-org.apache.uima.analysis_engine.annotator.jtextannotator_implbase
[org.apache.uima.analysis_engine.metadata.CapabilityLanguageFlow]: #user-content-org.apache.uima.analysis_engine.metadata.capabilitylanguageflow
[org.apache.uima.analysis_engine.metadata.FixedFlow]: #user-content-org.apache.uima.analysis_engine.metadata.fixedflow
[org.apache.uima.cas.CAS]: #user-content-org.apache.uima.cas.cas
[org.apache.uima.cas.FeaturePath]: #user-content-org.apache.uima.cas.featurepath
[org.apache.uima.cas.FeatureValuePath]: #user-content-org.apache.uima.cas.featurevaluepath
[org.apache.uima.cas.SofaID]: #user-content-org.apache.uima.cas.sofaid
[org.apache.uima.cas.admin.CASFactory]: #user-content-org.apache.uima.cas.admin.casfactory
[org.apache.uima.cas.admin.CASMgr]: #user-content-org.apache.uima.cas.admin.casmgr
[org.apache.uima.collection.CasInitializer]: #user-content-org.apache.uima.collection.casinitializer
[org.apache.uima.collection.CasInitializerDescription]: #user-content-org.apache.uima.collection.casinitializerdescription
[org.apache.uima.collection.CasInitializer_ImplBase]: #user-content-org.apache.uima.collection.casinitializer_implbase
[org.apache.uima.collection.CollectionReader]: #user-content-org.apache.uima.collection.collectionreader
[org.apache.uima.collection.CollectionReader_ImplBase]: #user-content-org.apache.uima.collection.collectionreader_implbase
[org.apache.uima.collection.base_cpm.CasDataCollectionReader]: #user-content-org.apache.uima.collection.base_cpm.casdatacollectionreader
[org.apache.uima.collection.base_cpm.CasDataInitializer]: #user-content-org.apache.uima.collection.base_cpm.casdatainitializer
[org.apache.uima.collection.base_cpm.CasDataInitializer_ImplBase]: #user-content-org.apache.uima.collection.base_cpm.casdatainitializer_implbase
[org.apache.uima.collection.metadata.CpeCasProcessor]: #user-content-org.apache.uima.collection.metadata.cpecasprocessor
[org.apache.uima.collection.metadata.CpeCollectionReader]: #user-content-org.apache.uima.collection.metadata.cpecollectionreader
[org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer]: #user-content-org.apache.uima.collection.metadata.cpecollectionreadercasinitializer
[org.apache.uima.collection.metadata.CpeDescription]: #user-content-org.apache.uima.collection.metadata.cpedescription
[org.apache.uima.collection.metadata.CpeSofaMappings]: #user-content-org.apache.uima.collection.metadata.cpesofamappings
[org.apache.uima.flow.CasFlow_ImplBase]: #user-content-org.apache.uima.flow.casflow_implbase
[org.apache.uima.jcas.JCas]: #user-content-org.apache.uima.jcas.jcas
[org.apache.uima.jcas.cas.ArrayFSImpl]: #user-content-org.apache.uima.jcas.cas.arrayfsimpl
[org.apache.uima.jcas.tcas.Annotation]: #user-content-org.apache.uima.jcas.tcas.annotation
[org.apache.uima.pear.tools.InstallationController]: #user-content-org.apache.uima.pear.tools.installationcontroller
[org.apache.uima.pear.tools.InstallationDescriptor]: #user-content-org.apache.uima.pear.tools.installationdescriptor
[org.apache.uima.resource.CustomResourceSpecifier]: #user-content-org.apache.uima.resource.customresourcespecifier
[org.apache.uima.resource.ParameterizedDataResource]: #user-content-org.apache.uima.resource.parameterizeddataresource
[org.apache.uima.resource.RelativePathResolver]: #user-content-org.apache.uima.resource.relativepathresolver
[org.apache.uima.resource.ResourceCreationSpecifier]: #user-content-org.apache.uima.resource.resourcecreationspecifier
[org.apache.uima.resource.ResourceManager]: #user-content-org.apache.uima.resource.resourcemanager
[org.apache.uima.resource.URISpecifier]: #user-content-org.apache.uima.resource.urispecifier
[org.apache.uima.resource.metadata.Capability]: #user-content-org.apache.uima.resource.metadata.capability
[org.apache.uima.resource.metadata.ConfigurationGroup]: #user-content-org.apache.uima.resource.metadata.configurationgroup
[org.apache.uima.resource.metadata.ConfigurationParameter]: #user-content-org.apache.uima.resource.metadata.configurationparameter
[org.apache.uima.resource.metadata.ConfigurationParameterDeclarations]: #user-content-org.apache.uima.resource.metadata.configurationparameterdeclarations
[org.apache.uima.resource.metadata.ConfigurationParameterSettings]: #user-content-org.apache.uima.resource.metadata.configurationparametersettings
[org.apache.uima.resource.metadata.FsIndexCollection]: #user-content-org.apache.uima.resource.metadata.fsindexcollection
[org.apache.uima.resource.metadata.FsIndexDescription]: #user-content-org.apache.uima.resource.metadata.fsindexdescription
[org.apache.uima.resource.metadata.LanguagePrecondition]: #user-content-org.apache.uima.resource.metadata.languageprecondition
[org.apache.uima.resource.metadata.MetaDataObject]: #user-content-org.apache.uima.resource.metadata.metadataobject
[org.apache.uima.resource.metadata.MimeTypePrecondition]: #user-content-org.apache.uima.resource.metadata.mimetypeprecondition
[org.apache.uima.resource.metadata.ProcessingResourceMetaData]: #user-content-org.apache.uima.resource.metadata.processingresourcemetadata
[org.apache.uima.resource.metadata.ResourceManagerConfiguration]: #user-content-org.apache.uima.resource.metadata.resourcemanagerconfiguration
[org.apache.uima.resource.metadata.TypeDescription]: #user-content-org.apache.uima.resource.metadata.typedescription
[org.apache.uima.resource.metadata.TypePriorities]: #user-content-org.apache.uima.resource.metadata.typepriorities
[org.apache.uima.resource.metadata.TypePriorityList]: #user-content-org.apache.uima.resource.metadata.typeprioritylist
[org.apache.uima.resource.metadata.TypeSystemDescription]: #user-content-org.apache.uima.resource.metadata.typesystemdescription
[org.apache.uima.spi.FsIndexCollectionProvider]: #user-content-org.apache.uima.spi.fsindexcollectionprovider
[org.apache.uima.spi.JCasClassProvider]: #user-content-org.apache.uima.spi.jcasclassprovider
[org.apache.uima.spi.TypePrioritiesProvider]: #user-content-org.apache.uima.spi.typeprioritiesprovider
[org.apache.uima.spi.TypeSystemDescriptionProvider]: #user-content-org.apache.uima.spi.typesystemdescriptionprovider
[org.apache.uima.spi.TypeSystemProvider]: #user-content-org.apache.uima.spi.typesystemprovider
[org.apache.uima.spi.TypeSystemProvider_ImplBase]: #user-content-org.apache.uima.spi.typesystemprovider_implbase
[org.apache.uima.uimacpp.CppUimajEngine]: #user-content-org.apache.uima.uimacpp.cppuimajengine
[org.apache.uima.uimacpp.UimacppAnalysisComponent]: #user-content-org.apache.uima.uimacpp.uimacppanalysiscomponent
[org.apache.uima.uimacpp.UimacppEngine]: #user-content-org.apache.uima.uimacpp.uimacppengine
[org.apache.uima.util.Logger]: #user-content-org.apache.uima.util.logger
[org.apache.uima.util.TypeSystemUtil]: #user-content-org.apache.uima.util.typesystemutil
[org.apache.uima.util.XMLInputSource]: #user-content-org.apache.uima.util.xmlinputsource
[org.apache.uima.util.XMLParser]: #user-content-org.apache.uima.util.xmlparser
