/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.carrotsearch.hppc.ObjectHashSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.elasticsearch.Assertions;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.ReloadableCustomAnalyzer;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.DocumentMapperForType;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperMergeValidator;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperUtils;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.similarity.SimilarityService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.mapper.MapperRegistry;
import org.elasticsearch.search.suggest.completion.context.ContextMapping;

public class MapperService
extends AbstractIndexComponent
implements Closeable {
    public static final String DEFAULT_MAPPING = "_default_";
    public static final String SINGLE_MAPPING_NAME = "_doc";
    public static final Setting<Long> INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_fields.limit", 50L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_NESTED_DOCS_LIMIT_SETTING = Setting.longSetting("index.mapping.nested_objects.limit", 10000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING = Setting.longSetting("index.mapping.total_fields.limit", 1000L, 0L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_DEPTH_LIMIT_SETTING = Setting.longSetting("index.mapping.depth.limit", 20L, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final Setting<Long> INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING = Setting.longSetting("index.mapping.field_name_length.limit", Long.MAX_VALUE, 1L, Setting.Property.Dynamic, Setting.Property.IndexScope);
    public static final boolean INDEX_MAPPER_DYNAMIC_DEFAULT = true;
    @Deprecated
    public static final Setting<Boolean> INDEX_MAPPER_DYNAMIC_SETTING = Setting.boolSetting("index.mapper.dynamic", true, Setting.Property.Dynamic, Setting.Property.IndexScope, Setting.Property.Deprecated);
    private static final String[] SORTED_META_FIELDS = new String[]{"_id", "_ignored", "_index", "_routing", "_size", "_timestamp", "_ttl", "_type"};
    private static final ObjectHashSet<String> META_FIELDS = ObjectHashSet.from((Object[])SORTED_META_FIELDS);
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(MapperService.class));
    private final IndexAnalyzers indexAnalyzers;
    private volatile String defaultMappingSource;
    private volatile DocumentMapper mapper;
    private volatile DocumentMapper defaultMapper;
    private volatile FieldTypeLookup fieldTypes;
    private volatile Map<String, ObjectMapper> fullPathObjectMappers = Collections.emptyMap();
    private boolean hasNested = false;
    private final DocumentMapperParser documentParser;
    private final MapperAnalyzerWrapper indexAnalyzer;
    private final MapperAnalyzerWrapper searchAnalyzer;
    private final MapperAnalyzerWrapper searchQuoteAnalyzer;
    private volatile Map<String, MappedFieldType> unmappedFieldTypes = Collections.emptyMap();
    final MapperRegistry mapperRegistry;

    public MapperService(IndexSettings indexSettings, IndexAnalyzers indexAnalyzers, NamedXContentRegistry xContentRegistry, SimilarityService similarityService, MapperRegistry mapperRegistry, Supplier<QueryShardContext> queryShardContextSupplier) {
        super(indexSettings);
        this.indexAnalyzers = indexAnalyzers;
        this.fieldTypes = new FieldTypeLookup();
        this.documentParser = new DocumentMapperParser(indexSettings, this, xContentRegistry, similarityService, mapperRegistry, queryShardContextSupplier);
        this.indexAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultIndexAnalyzer(), p -> p.indexAnalyzer());
        this.searchAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchAnalyzer(), p -> p.searchAnalyzer());
        this.searchQuoteAnalyzer = new MapperAnalyzerWrapper((Analyzer)indexAnalyzers.getDefaultSearchQuoteAnalyzer(), p -> p.searchQuoteAnalyzer());
        this.mapperRegistry = mapperRegistry;
        if (INDEX_MAPPER_DYNAMIC_SETTING.exists(indexSettings.getSettings()) && indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Setting " + INDEX_MAPPER_DYNAMIC_SETTING.getKey() + " was removed after version 6.0.0");
        }
        this.defaultMappingSource = "{\"_default_\":{}}";
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("default mapping source[{}]", (Object)this.defaultMappingSource);
        }
    }

    public boolean hasNested() {
        return this.hasNested;
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.indexAnalyzers;
    }

    public NamedAnalyzer getNamedAnalyzer(String analyzerName) {
        return this.indexAnalyzers.get(analyzerName);
    }

    public DocumentMapperParser documentMapperParser() {
        return this.documentParser;
    }

    public static Map<String, Object> parseMapping(NamedXContentRegistry xContentRegistry, String mappingSource) throws Exception {
        try (XContentParser parser = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, mappingSource);){
            Map<String, Object> map = parser.map();
            return map;
        }
    }

    public boolean updateMapping(IndexMetaData currentIndexMetaData, IndexMetaData newIndexMetaData) throws IOException {
        Map<String, DocumentMapper> updatedEntries;
        assert (newIndexMetaData.getIndex().equals(this.index())) : "index mismatch: expected " + this.index() + " but was " + newIndexMetaData.getIndex();
        HashSet<String> existingMappers = new HashSet<String>();
        if (this.mapper != null) {
            existingMappers.add(this.mapper.type());
        }
        if (this.defaultMapper != null) {
            existingMappers.add(DEFAULT_MAPPING);
        }
        try {
            updatedEntries = this.internalMerge(newIndexMetaData, MergeReason.MAPPING_RECOVERY, true);
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to apply mappings", (Object)this.index()), (Throwable)e);
            throw e;
        }
        boolean requireRefresh = false;
        this.assertMappingVersion(currentIndexMetaData, newIndexMetaData, updatedEntries);
        for (DocumentMapper documentMapper : updatedEntries.values()) {
            String op;
            MappingMetaData mappingMetaData;
            String mappingType = documentMapper.type();
            if (mappingType.equals(DEFAULT_MAPPING)) {
                mappingMetaData = newIndexMetaData.defaultMapping();
            } else {
                mappingMetaData = newIndexMetaData.mapping();
                assert (mappingType.equals(mappingMetaData.type()));
            }
            CompressedXContent incomingMappingSource = mappingMetaData.source();
            String string = op = existingMappers.contains(mappingType) ? "updated" : "added";
            if (this.logger.isDebugEnabled() && incomingMappingSource.compressed().length < 512) {
                this.logger.debug("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] {} mapping [{}], source [{}]", (Object)this.index(), (Object)op, (Object)mappingType, (Object)incomingMappingSource.string());
            } else {
                this.logger.debug("[{}] {} mapping [{}] (source suppressed due to length, use TRACE level if needed)", (Object)this.index(), (Object)op, (Object)mappingType);
            }
            if (this.documentMapper(mappingType).mappingSource().equals(incomingMappingSource)) continue;
            this.logger.debug("[{}] parsed mapping [{}], and got different sources\noriginal:\n{}\nparsed:\n{}", (Object)this.index(), (Object)mappingType, (Object)incomingMappingSource, (Object)this.documentMapper(mappingType).mappingSource());
            requireRefresh = true;
        }
        return requireRefresh;
    }

    private void assertMappingVersion(IndexMetaData currentIndexMetaData, IndexMetaData newIndexMetaData, Map<String, DocumentMapper> updatedEntries) {
        if (Assertions.ENABLED && currentIndexMetaData != null && currentIndexMetaData.getCreationVersion().onOrAfter(Version.V_6_5_0)) {
            if (currentIndexMetaData.getMappingVersion() == newIndexMetaData.getMappingVersion()) {
                MappingMetaData mapping;
                assert (updatedEntries.isEmpty()) : updatedEntries;
                MappingMetaData defaultMapping = newIndexMetaData.defaultMapping();
                if (defaultMapping != null) {
                    CompressedXContent currentSource = currentIndexMetaData.defaultMapping().source();
                    CompressedXContent newSource = defaultMapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + defaultMapping.type() + "] to be the same as new mapping [" + newSource + "]";
                }
                if ((mapping = newIndexMetaData.mapping()) != null) {
                    CompressedXContent currentSource = currentIndexMetaData.mapping().source();
                    CompressedXContent newSource = mapping.source();
                    assert (currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + mapping.type() + "] to be the same as new mapping [" + newSource + "]";
                }
            } else {
                long currentMappingVersion = currentIndexMetaData.getMappingVersion();
                long newMappingVersion = newIndexMetaData.getMappingVersion();
                assert (currentMappingVersion < newMappingVersion) : "expected current mapping version [" + currentMappingVersion + "] to be less than new mapping version [" + newMappingVersion + "]";
                assert (!updatedEntries.isEmpty());
                for (DocumentMapper documentMapper : updatedEntries.values()) {
                    MappingMetaData currentMapping;
                    if (documentMapper.type().equals(DEFAULT_MAPPING)) {
                        currentMapping = currentIndexMetaData.defaultMapping();
                    } else {
                        currentMapping = currentIndexMetaData.mapping();
                        assert (currentMapping == null || documentMapper.type().equals(currentMapping.type()));
                    }
                    if (currentMapping == null) continue;
                    CompressedXContent currentSource = currentMapping.source();
                    CompressedXContent newSource = documentMapper.mappingSource();
                    assert (!currentSource.equals(newSource)) : "expected current mapping [" + currentSource + "] for type [" + documentMapper.type() + "] to be different than new mapping";
                }
            }
        }
    }

    public void merge(Map<String, Map<String, Object>> mappings, MergeReason reason) {
        LinkedHashMap<String, CompressedXContent> mappingSourcesCompressed = new LinkedHashMap<String, CompressedXContent>(mappings.size());
        for (Map.Entry<String, Map<String, Object>> entry : mappings.entrySet()) {
            try {
                mappingSourcesCompressed.put(entry.getKey(), new CompressedXContent(Strings.toString(XContentFactory.jsonBuilder().map(entry.getValue()))));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        this.internalMerge(mappingSourcesCompressed, reason);
    }

    public void merge(IndexMetaData indexMetaData, MergeReason reason) {
        this.internalMerge(indexMetaData, reason, false);
    }

    public DocumentMapper merge(String type, CompressedXContent mappingSource, MergeReason reason) {
        return this.internalMerge(Collections.singletonMap(type, mappingSource), reason).get(type);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(IndexMetaData indexMetaData, MergeReason reason, boolean onlyUpdateIfNeeded) {
        LinkedHashMap<String, CompressedXContent> map = new LinkedHashMap<String, CompressedXContent>();
        for (ObjectCursor cursor : indexMetaData.getMappings().values()) {
            MappingMetaData mappingMetaData = (MappingMetaData)cursor.value;
            if (onlyUpdateIfNeeded) {
                DocumentMapper existingMapper = this.documentMapper(mappingMetaData.type());
                if (existingMapper != null && mappingMetaData.source().equals(existingMapper.mappingSource())) continue;
                map.put(mappingMetaData.type(), mappingMetaData.source());
                continue;
            }
            map.put(mappingMetaData.type(), mappingMetaData.source());
        }
        return this.internalMerge(map, reason);
    }

    private synchronized Map<String, DocumentMapper> internalMerge(Map<String, CompressedXContent> mappings, MergeReason reason) {
        DocumentMapper defaultMapper = null;
        String defaultMappingSource = null;
        if (mappings.containsKey(DEFAULT_MAPPING)) {
            try {
                defaultMapper = this.documentParser.parse(DEFAULT_MAPPING, mappings.get(DEFAULT_MAPPING));
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, DEFAULT_MAPPING, e.getMessage());
            }
            defaultMappingSource = mappings.get(DEFAULT_MAPPING).string();
        }
        String defaultMappingSourceOrLastStored = defaultMappingSource != null ? defaultMappingSource : this.defaultMappingSource;
        DocumentMapper documentMapper = null;
        for (Map.Entry<String, CompressedXContent> entry : mappings.entrySet()) {
            String type = entry.getKey();
            if (type.equals(DEFAULT_MAPPING)) continue;
            if (documentMapper != null) {
                throw new IllegalArgumentException("Cannot put multiple mappings: " + mappings.keySet());
            }
            boolean applyDefault = reason != MergeReason.MAPPING_RECOVERY && this.mapper == null;
            try {
                documentMapper = this.documentParser.parse(type, entry.getValue(), applyDefault ? defaultMappingSourceOrLastStored : null);
            }
            catch (Exception e) {
                throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
            }
        }
        return this.internalMerge(defaultMapper, defaultMappingSource, documentMapper, reason);
    }

    static void validateTypeName(String type) {
        if (type.length() == 0) {
            throw new InvalidTypeNameException("mapping type name is empty");
        }
        if (type.length() > 255) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] is too long; limit is length 255 but was [" + type.length() + "]");
        }
        if (type.charAt(0) == '_' && !SINGLE_MAPPING_NAME.equals(type)) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] can't start with '_' unless it is called [" + SINGLE_MAPPING_NAME + "]");
        }
        if (type.contains("#")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include '#' in it");
        }
        if (type.contains(",")) {
            throw new InvalidTypeNameException("mapping type name [" + type + "] should not include ',' in it");
        }
        if (type.charAt(0) == '.') {
            throw new IllegalArgumentException("mapping type name [" + type + "] must not start with a '.'");
        }
    }

    private synchronized Map<String, DocumentMapper> internalMerge(@Nullable DocumentMapper defaultMapper, @Nullable String defaultMappingSource, DocumentMapper mapper, MergeReason reason) {
        DocumentMapper updatedDocumentMapper;
        boolean hasNested = this.hasNested;
        Map<String, ObjectMapper> fullPathObjectMappers = this.fullPathObjectMappers;
        FieldTypeLookup fieldTypes = this.fieldTypes;
        Map<String, DocumentMapper> results = new LinkedHashMap<String, DocumentMapper>(2);
        if (defaultMapper != null) {
            if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("The [default] mapping cannot be updated on index [" + this.index().getName() + "]: defaults mappings are not useful anymore now that indices can have at most one type.");
            }
            if (reason == MergeReason.MAPPING_UPDATE) {
                deprecationLogger.deprecated("[_default_] mapping is deprecated since it is not useful anymore now that indexes cannot have more than one type", new Object[0]);
            }
            assert (defaultMapper.type().equals(DEFAULT_MAPPING));
            results.put(DEFAULT_MAPPING, defaultMapper);
        }
        DocumentMapper newMapper = null;
        if (mapper != null) {
            MapperService.validateTypeName(mapper.type());
            DocumentMapper oldMapper = this.mapper;
            newMapper = oldMapper != null ? oldMapper.merge(mapper.mapping()) : mapper;
            ArrayList<ObjectMapper> objectMappers = new ArrayList<ObjectMapper>();
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            ArrayList<FieldAliasMapper> fieldAliasMappers = new ArrayList<FieldAliasMapper>();
            MetadataFieldMapper[] metadataMappers = newMapper.mapping().metadataMappers;
            Collections.addAll(fieldMappers, metadataMappers);
            MapperUtils.collect(newMapper.mapping().root(), objectMappers, fieldMappers, fieldAliasMappers);
            MapperMergeValidator.validateNewMappers(objectMappers, fieldMappers, fieldAliasMappers, fieldTypes);
            this.checkPartitionedIndexConstraints(newMapper);
            fieldTypes = fieldTypes.copyAndAddAll(newMapper.type(), fieldMappers, fieldAliasMappers);
            for (ObjectMapper objectMapper : objectMappers) {
                if (fullPathObjectMappers == this.fullPathObjectMappers) {
                    fullPathObjectMappers = new HashMap<String, ObjectMapper>(this.fullPathObjectMappers);
                }
                fullPathObjectMappers.put(objectMapper.fullPath(), objectMapper);
                if (!objectMapper.nested().isNested()) continue;
                hasNested = true;
            }
            MapperMergeValidator.validateFieldReferences(fieldMappers, fieldAliasMappers, fullPathObjectMappers, fieldTypes);
            ContextMapping.validateContextPaths(this.indexSettings.getIndexVersionCreated(), fieldMappers, fieldTypes::get);
            if (reason == MergeReason.MAPPING_UPDATE) {
                this.checkTotalFieldsLimit(objectMappers.size() + fieldMappers.size() - metadataMappers.length + fieldAliasMappers.size());
                this.checkFieldNameSoftLimit(objectMappers, fieldMappers, fieldAliasMappers);
            }
            results.put(newMapper.type(), newMapper);
        }
        if (reason == MergeReason.MAPPING_UPDATE) {
            this.checkNestedFieldsLimit(fullPathObjectMappers);
            this.checkDepthLimit(fullPathObjectMappers.keySet());
        }
        MapperService.checkIndexSortCompatibility(this.indexSettings.getIndexSortConfig(), hasNested);
        if (newMapper != null && (updatedDocumentMapper = newMapper.updateFieldType(fieldTypes.fullNameToFieldType)) != newMapper) {
            newMapper = updatedDocumentMapper;
            results.put(updatedDocumentMapper.type(), updatedDocumentMapper);
        }
        results = Collections.unmodifiableMap(results);
        if (fullPathObjectMappers != this.fullPathObjectMappers) {
            fullPathObjectMappers = Collections.unmodifiableMap(fullPathObjectMappers);
        }
        if (defaultMappingSource != null) {
            this.defaultMappingSource = defaultMappingSource;
            this.defaultMapper = defaultMapper;
        }
        if (newMapper != null) {
            this.mapper = newMapper;
        }
        this.fieldTypes = fieldTypes;
        this.hasNested = hasNested;
        this.fullPathObjectMappers = fullPathObjectMappers;
        assert (this.assertMappersShareSameFieldType());
        assert (results.values().stream().allMatch(this::assertSerialization));
        return results;
    }

    private boolean assertMappersShareSameFieldType() {
        if (this.mapper != null) {
            ArrayList<FieldMapper> fieldMappers = new ArrayList<FieldMapper>();
            Collections.addAll(fieldMappers, this.mapper.mapping().metadataMappers);
            MapperUtils.collect(this.mapper.root(), new ArrayList<ObjectMapper>(), fieldMappers, new ArrayList<FieldAliasMapper>());
            for (FieldMapper fieldMapper : fieldMappers) {
                assert (fieldMapper.fieldType() == this.fieldTypes.get(fieldMapper.name())) : fieldMapper.name();
            }
        }
        return true;
    }

    private boolean assertSerialization(DocumentMapper mapper) {
        CompressedXContent mappingSource = mapper.mappingSource();
        DocumentMapper newMapper = this.parse(mapper.type(), mappingSource, false);
        if (!newMapper.mappingSource().equals(mappingSource)) {
            throw new IllegalStateException("DocumentMapper serialization result is different from source. \n--> Source [" + mappingSource + "]\n--> Result [" + newMapper.mappingSource() + "]");
        }
        return true;
    }

    private void checkNestedFieldsLimit(Map<String, ObjectMapper> fullPathObjectMappers) {
        long allowedNestedFields = this.indexSettings.getValue(INDEX_MAPPING_NESTED_FIELDS_LIMIT_SETTING);
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : fullPathObjectMappers.values()) {
            if (!objectMapper.nested().isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > allowedNestedFields) {
            throw new IllegalArgumentException("Limit of nested fields [" + allowedNestedFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkTotalFieldsLimit(long totalMappers) {
        long allowedTotalFields = this.indexSettings.getValue(INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING);
        if (allowedTotalFields < totalMappers) {
            throw new IllegalArgumentException("Limit of total fields [" + allowedTotalFields + "] in index [" + this.index().getName() + "] has been exceeded");
        }
    }

    private void checkDepthLimit(Collection<String> objectPaths) {
        long maxDepth = this.indexSettings.getValue(INDEX_MAPPING_DEPTH_LIMIT_SETTING);
        for (String objectPath : objectPaths) {
            this.checkDepthLimit(objectPath, maxDepth);
        }
    }

    private void checkDepthLimit(String objectPath, long maxDepth) {
        int numDots = 0;
        for (int i = 0; i < objectPath.length(); ++i) {
            if (objectPath.charAt(i) != '.') continue;
            ++numDots;
        }
        int depth = numDots + 2;
        if ((long)depth > maxDepth) {
            throw new IllegalArgumentException("Limit of mapping depth [" + maxDepth + "] in index [" + this.index().getName() + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkFieldNameSoftLimit(Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers) {
        long maxFieldNameLength = this.indexSettings.getValue(INDEX_MAPPING_FIELD_NAME_LENGTH_LIMIT_SETTING);
        Stream.of(objectMappers.stream(), fieldMappers.stream(), fieldAliasMappers.stream()).reduce(Stream::concat).orElseGet(Stream::empty).forEach(mapper -> {
            String name = mapper.simpleName();
            if ((long)name.length() > maxFieldNameLength) {
                throw new IllegalArgumentException("Field name [" + name + "] in index [" + this.index().getName() + "] is too long. The limit is set to [" + maxFieldNameLength + "] characters but was [" + name.length() + "] characters");
            }
        });
    }

    private void checkPartitionedIndexConstraints(DocumentMapper newMapper) {
        if (this.indexSettings.getIndexMetaData().isRoutingPartitionedIndex() && !newMapper.routingFieldMapper().required()) {
            throw new IllegalArgumentException("mapping type [" + newMapper.type() + "] must have routing required for partitioned index [" + this.indexSettings.getIndex().getName() + "]");
        }
    }

    private static void checkIndexSortCompatibility(IndexSortConfig sortConfig, boolean hasNested) {
        if (sortConfig.hasIndexSort() && hasNested) {
            throw new IllegalArgumentException("cannot have nested fields when index sort is activated");
        }
    }

    public DocumentMapper parse(String mappingType, CompressedXContent mappingSource, boolean applyDefault) throws MapperParsingException {
        return this.documentParser.parse(mappingType, mappingSource, applyDefault ? this.defaultMappingSource : null);
    }

    public DocumentMapper documentMapper() {
        return this.mapper;
    }

    public DocumentMapper documentMapper(String type) {
        if (this.mapper != null && type.equals(this.mapper.type())) {
            return this.mapper;
        }
        if (DEFAULT_MAPPING.equals(type)) {
            return this.defaultMapper;
        }
        return null;
    }

    public static boolean isMappingSourceTyped(String type, Map<String, Object> mapping) {
        return mapping.size() == 1 && mapping.keySet().iterator().next().equals(type);
    }

    public static boolean isMappingSourceTyped(String type, CompressedXContent mappingSource) {
        Map<String, Object> root = XContentHelper.convertToMap(mappingSource.compressedReference(), true, XContentType.JSON).v2();
        return MapperService.isMappingSourceTyped(type, root);
    }

    public String getTypeForUpdate(String type, CompressedXContent mappingSource) {
        return !MapperService.isMappingSourceTyped(type, mappingSource) ? this.resolveDocumentType(type) : type;
    }

    public String resolveDocumentType(String type) {
        if (SINGLE_MAPPING_NAME.equals(type) && this.mapper != null) {
            return this.mapper.type();
        }
        return type;
    }

    public DocumentMapperForType documentMapperWithAutoCreate(String type) {
        DocumentMapper mapper = this.documentMapper(type);
        if (mapper != null) {
            return new DocumentMapperForType(mapper, null);
        }
        mapper = this.parse(type, null, true);
        return new DocumentMapperForType(mapper, mapper.mapping());
    }

    public MappedFieldType fullName(String fullName) {
        return this.fieldTypes.get(fullName);
    }

    public Set<String> simpleMatchToFullName(String pattern) {
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        return this.fieldTypes.simpleMatchToFullName(pattern);
    }

    public Iterable<MappedFieldType> fieldTypes() {
        return this.fieldTypes;
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.fullPathObjectMappers.get(name);
    }

    public MappedFieldType unmappedFieldType(String type) {
        MappedFieldType fieldType;
        if (type.equals("string")) {
            deprecationLogger.deprecated("[unmapped_type:string] should be replaced with [unmapped_type:keyword]", new Object[0]);
            type = "keyword";
        }
        if ((fieldType = this.unmappedFieldTypes.get(type)) == null) {
            Mapper.TypeParser.ParserContext parserContext = this.documentMapperParser().parserContext();
            Mapper.TypeParser typeParser = parserContext.typeParser(type);
            if (typeParser == null) {
                throw new IllegalArgumentException("No mapper found for type [" + type + "]");
            }
            Mapper.Builder<?, ?> builder = typeParser.parse("__anonymous_" + type, Collections.emptyMap(), parserContext);
            Mapper.BuilderContext builderContext = new Mapper.BuilderContext(this.indexSettings.getSettings(), new ContentPath(1));
            fieldType = ((FieldMapper)builder.build(builderContext)).fieldType();
            HashMap<String, MappedFieldType> newUnmappedFieldTypes = new HashMap<String, MappedFieldType>(this.unmappedFieldTypes);
            newUnmappedFieldTypes.put(type, fieldType);
            this.unmappedFieldTypes = Collections.unmodifiableMap(newUnmappedFieldTypes);
        }
        return fieldType;
    }

    public Analyzer indexAnalyzer() {
        return this.indexAnalyzer;
    }

    public Analyzer searchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Analyzer searchQuoteAnalyzer() {
        return this.searchQuoteAnalyzer;
    }

    @Override
    public void close() throws IOException {
        this.indexAnalyzers.close();
    }

    public static boolean isMetadataField(String fieldName) {
        return META_FIELDS.contains((Object)fieldName);
    }

    public static String[] getAllMetaFields() {
        return Arrays.copyOf(SORTED_META_FIELDS, SORTED_META_FIELDS.length);
    }

    public synchronized List<String> reloadSearchAnalyzers(AnalysisRegistry registry) throws IOException {
        this.logger.info("reloading search analyzers");
        Map<String, TokenizerFactory> tokenizerFactories = registry.buildTokenizerFactories(this.indexSettings);
        Map<String, CharFilterFactory> charFilterFactories = registry.buildCharFilterFactories(this.indexSettings);
        Map<String, TokenFilterFactory> tokenFilterFactories = registry.buildTokenFilterFactories(this.indexSettings);
        Map<String, Settings> settings = this.indexSettings.getSettings().getGroups("index.analysis.analyzer");
        ArrayList<String> reloadedAnalyzers = new ArrayList<String>();
        for (NamedAnalyzer namedAnalyzer : this.indexAnalyzers.getAnalyzers().values()) {
            if (!(namedAnalyzer.analyzer() instanceof ReloadableCustomAnalyzer)) continue;
            ReloadableCustomAnalyzer analyzer = (ReloadableCustomAnalyzer)namedAnalyzer.analyzer();
            String analyzerName = namedAnalyzer.name();
            Settings analyzerSettings = settings.get(analyzerName);
            analyzer.reload(analyzerName, analyzerSettings, tokenizerFactories, charFilterFactories, tokenFilterFactories);
            reloadedAnalyzers.add(analyzerName);
        }
        return reloadedAnalyzers;
    }

    final class MapperAnalyzerWrapper
    extends DelegatingAnalyzerWrapper {
        private final Analyzer defaultAnalyzer;
        private final Function<MappedFieldType, Analyzer> extractAnalyzer;

        MapperAnalyzerWrapper(Analyzer defaultAnalyzer, Function<MappedFieldType, Analyzer> extractAnalyzer) {
            super(Analyzer.PER_FIELD_REUSE_STRATEGY);
            this.defaultAnalyzer = defaultAnalyzer;
            this.extractAnalyzer = extractAnalyzer;
        }

        protected Analyzer getWrappedAnalyzer(String fieldName) {
            Analyzer analyzer;
            MappedFieldType fieldType = MapperService.this.fullName(fieldName);
            if (fieldType != null && (analyzer = this.extractAnalyzer.apply(fieldType)) != null) {
                return analyzer;
            }
            return this.defaultAnalyzer;
        }
    }

    public static enum MergeReason {
        MAPPING_UPDATE,
        MAPPING_RECOVERY;

    }
}

