/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.TransactionCommitCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionCreateCodec;
import com.hazelcast.client.impl.protocol.codec.TransactionRollbackCodec;
import com.hazelcast.client.proxy.txn.ClientTransactionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;

final class TransactionProxy {
    private static final ThreadLocal<Boolean> TRANSACTION_EXISTS = new ThreadLocal();
    private final TransactionOptions options;
    private final HazelcastClientInstanceImpl client;
    private final long threadId = ThreadUtil.getThreadId();
    private final ClientConnection connection;
    private final ILogger logger;
    private String txnId;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime;

    TransactionProxy(HazelcastClientInstanceImpl client, TransactionOptions options, ClientConnection connection) {
        this.options = options;
        this.client = client;
        this.connection = connection;
        this.logger = client.getLoggingService().getLogger(TransactionProxy.class);
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    void begin() {
        try {
            if (this.client.getConnectionManager().getOwnerConnection() == null) {
                throw new TransactionException("Owner connection needs to be present to begin a transaction");
            }
            if (this.state == Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is already active");
            }
            this.checkThread();
            if (TRANSACTION_EXISTS.get() != null) {
                throw new IllegalStateException("Nested transactions are not allowed!");
            }
            TRANSACTION_EXISTS.set(Boolean.TRUE);
            this.startTime = Clock.currentTimeMillis();
            ClientMessage request = TransactionCreateCodec.encodeRequest(this.options.getTimeoutMillis(), this.options.getDurability(), this.options.getTransactionType().id(), this.threadId);
            ClientMessage response = ClientTransactionUtil.invoke(request, this.getTxnId(), this.client, this.connection);
            TransactionCreateCodec.ResponseParameters result = TransactionCreateCodec.decodeResponse(response);
            this.txnId = result.response;
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            TRANSACTION_EXISTS.set(null);
            throw ExceptionUtil.rethrow(e);
        }
    }

    void commit() {
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            this.state = Transaction.State.COMMITTING;
            this.checkThread();
            this.checkTimeout();
            ClientMessage request = TransactionCommitCodec.encodeRequest(this.txnId, this.threadId);
            ClientTransactionUtil.invoke(request, this.getTxnId(), this.client, this.connection);
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.COMMIT_FAILED;
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    void rollback() {
        try {
            if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
                throw new IllegalStateException("Transaction is not active");
            }
            this.state = Transaction.State.ROLLING_BACK;
            this.checkThread();
            try {
                ClientMessage request = TransactionRollbackCodec.encodeRequest(this.txnId, this.threadId);
                ClientTransactionUtil.invoke(request, this.getTxnId(), this.client, this.connection);
            }
            catch (Exception exception) {
                this.logger.warning("Exception while rolling back the transaction", exception);
            }
            this.state = Transaction.State.ROLLED_BACK;
        }
        finally {
            TRANSACTION_EXISTS.set(null);
        }
    }

    private void checkThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    private void checkTimeout() {
        if (this.startTime + this.options.getTimeoutMillis() < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }
}

