/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.actions.ActionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="action-list", description="This will list all the actions deployed in the Apache Unomi Context Server")
@Service
public class ActionList
extends ListCommandSupport {
    @Reference
    DefinitionsService definitionsService;

    @Override
    protected String[] getHeaders() {
        return new String[]{"Id", "Name", "System tags"};
    }

    @Override
    protected DataTable buildDataTable() {
        Collection allActions = this.definitionsService.getAllActionTypes();
        DataTable dataTable = new DataTable();
        for (ActionType actionType : allActions) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(actionType.getItemId());
            rowData.add(actionType.getMetadata().getName());
            rowData.add(StringUtils.join((Iterable)actionType.getMetadata().getSystemTags(), (String)","));
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        dataTable.sort(new DataTable.SortCriteria[]{new DataTable.SortCriteria(Integer.valueOf(1), DataTable.SortOrder.ASCENDING)});
        return dataTable;
    }
}

