/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.resource;

import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.settings.DefaultUnauthorizedResourceRequestListener;
import org.apache.wicket.util.lang.Args;

public class ResourceRequestHandler
implements IRequestHandler {
    private final IResource resource;
    private final PageParameters parameters;

    public ResourceRequestHandler(IResource resource, PageParameters parameters) {
        Args.notNull((Object)resource, (String)"resource");
        this.resource = resource;
        this.parameters = parameters != null ? parameters : new PageParameters();
        this.authorize();
    }

    private void authorize() {
        IAuthorizationStrategy authorizationStrategy = null;
        if (Session.exists()) {
            authorizationStrategy = Session.get().getAuthorizationStrategy();
        } else if (Application.exists()) {
            authorizationStrategy = Application.get().getSecuritySettings().getAuthorizationStrategy();
        }
        if (authorizationStrategy != null && !authorizationStrategy.isResourceAuthorized(this.resource, this.parameters)) {
            if (Application.exists()) {
                Application.get().getSecuritySettings().getUnauthorizedResourceRequestListener().onUnauthorizedRequest(this.resource, this.parameters);
            } else {
                new DefaultUnauthorizedResourceRequestListener().onUnauthorizedRequest(this.resource, this.parameters);
            }
        }
    }

    public PageParameters getPageParameters() {
        return this.parameters;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void respond(IRequestCycle requestCycle) {
        IResource.Attributes a = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse(), this.parameters);
        this.resource.respond(a);
    }
}

