/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.export;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.AbstractDataExporter;
import org.apache.wicket.extensions.markup.html.repeater.data.table.export.IExportableColumn;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.Args;

public class CSVDataExporter
extends AbstractDataExporter {
    private char delimiter = (char)44;
    private String characterSet = "utf-8";
    private char quoteCharacter = (char)34;
    private boolean exportHeadersEnabled = true;

    public CSVDataExporter() {
        super((IModel<String>)Model.of((Serializable)((Object)"CSV")), "text/csv", "csv");
    }

    public CSVDataExporter setDelimiter(char delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public CSVDataExporter setCharacterSet(String characterSet) {
        this.characterSet = (String)Args.notNull((Object)characterSet, (String)"characterSer");
        return this;
    }

    public char getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public CSVDataExporter setQuoteCharacter(char quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
        return this;
    }

    @Override
    public String getContentType() {
        return super.getContentType() + "; charset=" + this.characterSet + "; header=" + (this.exportHeadersEnabled ? "present" : "absent");
    }

    public CSVDataExporter setExportHeadersEnabled(boolean exportHeadersEnabled) {
        this.exportHeadersEnabled = exportHeadersEnabled;
        return this;
    }

    public boolean isExportHeadersEnabled() {
        return this.exportHeadersEnabled;
    }

    protected String quoteValue(String value) {
        return this.quoteCharacter + value.replace("" + this.quoteCharacter, "" + this.quoteCharacter + this.quoteCharacter) + this.quoteCharacter;
    }

    @Override
    public <T> void exportData(IDataProvider<T> dataProvider, List<IExportableColumn<T, ?>> columns, OutputStream outputStream) throws IOException {
        try (Grid grid = new Grid(new OutputStreamWriter(outputStream, Charset.forName(this.characterSet)));){
            this.writeHeaders(columns, grid);
            this.writeData(dataProvider, columns, grid);
        }
    }

    private <T> void writeHeaders(List<IExportableColumn<T, ?>> columns, Grid grid) throws IOException {
        if (this.isExportHeadersEnabled()) {
            for (IExportableColumn<T, ?> col : columns) {
                IModel<String> displayModel = col.getDisplayModel();
                String display = (String)this.wrapModel(displayModel).getObject();
                grid.cell(this.quoteValue(display));
            }
            grid.row();
        }
    }

    private <T> void writeData(IDataProvider<T> dataProvider, List<IExportableColumn<T, ?>> columns, Grid grid) throws IOException {
        long numberOfRows = dataProvider.size();
        Iterator rowIterator = dataProvider.iterator(0L, numberOfRows);
        while (rowIterator.hasNext()) {
            Object row = rowIterator.next();
            for (IExportableColumn<T, ?> col : columns) {
                IModel<?> dataModel = col.getDataModel(dataProvider.model(row));
                Object value = this.wrapModel(dataModel).getObject();
                if (value == null) continue;
                Class<?> c = value.getClass();
                IConverter converter = this.getConverterLocator().getConverter(c);
                String s = converter == null ? value.toString() : converter.convertToString(value, Session.get().getLocale());
                grid.cell(this.quoteValue(s));
            }
            grid.row();
        }
    }

    protected IConverterLocator getConverterLocator() {
        return Application.get().getConverterLocator();
    }

    protected <T> IModel<T> wrapModel(IModel<T> model) {
        return model;
    }

    private class Grid
    implements Closeable {
        private Writer writer;
        boolean first = true;

        public Grid(Writer writer) {
            this.writer = writer;
        }

        public void cell(String value) throws IOException {
            if (this.first) {
                this.first = false;
            } else {
                this.writer.write(CSVDataExporter.this.delimiter);
            }
            this.writer.write(value);
        }

        public void row() throws IOException {
            this.writer.write("\r\n");
            this.first = true;
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }
}

